/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTAstRoot;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptTreeBuilder;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ErrorCollector;
import org.mozilla.javascript.ast.ParseProblem;

public final class EcmascriptParser
implements net.sourceforge.pmd.lang.ast.Parser {
    private final LanguagePropertyBundle properties;

    public EcmascriptParser(LanguagePropertyBundle properties) {
        this.properties = properties;
    }

    private AstRoot parseEcmascript(String sourceCode, LanguageVersion version, List<ParseProblem> parseProblems) throws ParseException {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setRecordingComments(true);
        compilerEnvirons.setRecordingLocalJsDocComments(true);
        compilerEnvirons.setLanguageVersion(EcmascriptParser.determineRhinoLanguageVersion(version));
        compilerEnvirons.setIdeMode(true);
        compilerEnvirons.setWarnTrailingComma(true);
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        ErrorCollector errorCollector = new ErrorCollector();
        Parser parser = new Parser(compilerEnvirons, (ErrorReporter)errorCollector);
        String sourceURI = "unknown";
        boolean beginLineno = true;
        AstRoot astRoot = parser.parse(sourceCode, "unknown", 1);
        parseProblems.addAll(errorCollector.getErrors());
        return astRoot;
    }

    private static int determineRhinoLanguageVersion(LanguageVersion version) {
        switch (version.getVersion()) {
            case "3": {
                return 150;
            }
            case "5": {
                return 180;
            }
        }
        return 200;
    }

    public RootNode parse(Parser.ParserTask task) throws FileAnalysisException {
        LanguageVersion version = task.getLanguageVersion();
        ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
        AstRoot astRoot = this.parseEcmascript(task.getSourceText(), version, parseProblems);
        EcmascriptTreeBuilder treeBuilder = new EcmascriptTreeBuilder(parseProblems);
        ASTAstRoot tree = (ASTAstRoot)treeBuilder.build(astRoot);
        String suppressMarker = this.properties.getSuppressMarker();
        HashMap<Integer, String> suppressMap = new HashMap<Integer, String>();
        if (astRoot.getComments() != null) {
            for (Comment comment : astRoot.getComments()) {
                int nopmd = comment.getValue().indexOf(suppressMarker);
                if (nopmd <= -1) continue;
                String suppression = comment.getValue().substring(nopmd + suppressMarker.length());
                suppressMap.put(comment.getLineno(), suppression);
            }
        }
        tree.setAstInfo((AstInfo<ASTAstRoot>)new AstInfo(task, (RootNode)tree).withSuppressMap(suppressMap));
        return tree;
    }
}

