/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import net.sourceforge.pmd.lang.ecmascript.ast.ASTName;
import net.sourceforge.pmd.lang.ecmascript.ast.AbstractEcmascriptNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptVisitor;
import org.mozilla.javascript.ast.FunctionNode;

public final class ASTFunctionNode
extends AbstractEcmascriptNode<FunctionNode> {
    ASTFunctionNode(FunctionNode functionNode) {
        super(functionNode);
    }

    @Override
    protected <P, R> R acceptJsVisitor(EcmascriptVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public int getNumParams() {
        return ((FunctionNode)this.node).getParams().size();
    }

    public ASTName getFunctionName() {
        if (((FunctionNode)this.node).getFunctionName() != null) {
            return (ASTName)this.getChild(0);
        }
        return null;
    }

    public EcmascriptNode<?> getParam(int index) {
        int paramIndex = index;
        if (((FunctionNode)this.node).getFunctionName() != null) {
            paramIndex = index + 1;
        }
        return (EcmascriptNode)this.getChild(paramIndex);
    }

    public EcmascriptNode<?> getBody() {
        return (EcmascriptNode)this.getChild(this.getNumChildren() - 1);
    }

    public boolean isClosure() {
        return ((FunctionNode)this.node).isExpressionClosure();
    }

    public boolean isGetter() {
        return ((FunctionNode)this.node).isGetterMethod();
    }

    public boolean isSetter() {
        return ((FunctionNode)this.node).isSetterMethod();
    }

    public boolean isGetterOrSetter() {
        return this.isGetter() || this.isSetter();
    }
}

