/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.kotlin.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.kotlin.AbstractKotlinRule;
import net.sourceforge.pmd.lang.kotlin.ast.KotlinParser;
import net.sourceforge.pmd.lang.kotlin.ast.KotlinTerminalNode;
import net.sourceforge.pmd.lang.kotlin.ast.KotlinVisitor;
import net.sourceforge.pmd.lang.kotlin.ast.KotlinVisitorBase;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OverrideBothEqualsAndHashcodeRule
extends AbstractKotlinRule {
    private static final Visitor INSTANCE = new Visitor();

    @Override
    public KotlinVisitor<RuleContext, ?> buildVisitor() {
        return INSTANCE;
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(KotlinParser.KtClassMemberDeclarations.class, (Class[])new Class[0]);
    }

    private static final class Visitor
    extends KotlinVisitorBase<RuleContext, Void> {
        private Visitor() {
        }

        @Override
        public Void visitClassMemberDeclarations(KotlinParser.KtClassMemberDeclarations node, RuleContext data) {
            boolean hasHashCodeMethod;
            List functions = node.children(KotlinParser.KtClassMemberDeclaration.class).children(KotlinParser.KtDeclaration.class).children(KotlinParser.KtFunctionDeclaration.class).toList();
            boolean hasEqualMethod = functions.stream().filter(this::isEqualsMethod).count() == 1L;
            boolean bl = hasHashCodeMethod = functions.stream().filter(this::isHashCodeMethod).count() == 1L;
            if (hasEqualMethod ^ hasHashCodeMethod) {
                data.addViolation(node.ancestors(KotlinParser.KtClassDeclaration.class).first());
            }
            return (Void)super.visitClassMemberDeclarations(node, (Object)data);
        }

        private boolean isEqualsMethod(KotlinParser.KtFunctionDeclaration fun) {
            String name = this.getFunctionName(fun);
            int arity = this.getArity(fun);
            return "equals".equals(name) && this.hasOverrideModifier(fun) && arity == 1;
        }

        private boolean isHashCodeMethod(KotlinParser.KtFunctionDeclaration fun) {
            String name = this.getFunctionName(fun);
            int arity = this.getArity(fun);
            return "hashCode".equals(name) && this.hasOverrideModifier(fun) && arity == 0;
        }

        private String getFunctionName(KotlinParser.KtFunctionDeclaration fun) {
            return ((KotlinTerminalNode)fun.simpleIdentifier().children(KotlinTerminalNode.class).first()).getText();
        }

        private boolean hasOverrideModifier(KotlinParser.KtFunctionDeclaration fun) {
            return fun.modifiers().descendants(KotlinTerminalNode.class).any(t -> "override".equals(t.getText()));
        }

        private int getArity(KotlinParser.KtFunctionDeclaration fun) {
            return fun.functionValueParameters().functionValueParameter().size();
        }
    }
}

