/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.test;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;

public abstract class AbstractMetricTestRule<N extends Number>
extends AbstractRule {
    private final PropertyDescriptor<List<MetricOption>> optionsDescriptor = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"metricOptions", this.optionMappings()).desc("Choose a variant of the metric or the standard")).emptyDefaultValue().build();
    private final PropertyDescriptor<String> reportLevelDescriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"reportLevel").desc("Minimum value required to report")).defaultValue((Object)("" + this.defaultReportLevel()))).build();
    private final Metric<?, N> metric;

    public AbstractMetricTestRule(Metric<?, N> metric) {
        this.metric = metric;
        this.definePropertyDescriptor(this.reportLevelDescriptor);
        this.definePropertyDescriptor(this.optionsDescriptor);
    }

    protected abstract N parseReportLevel(String var1);

    protected boolean reportOn(Node node) {
        return this.metric.supports(node);
    }

    protected Map<String, MetricOption> optionMappings() {
        return new HashMap<String, MetricOption>();
    }

    protected abstract N defaultReportLevel();

    protected String violationMessage(Node node, N result) {
        return MessageFormat.format("At line {0} level {1}", node.getBeginLine(), result);
    }

    public void apply(Node target, RuleContext ctx) {
        if (this.reportOn(target)) {
            MetricOptions options = MetricOptions.ofOptions((Collection)((Collection)this.getProperty(this.optionsDescriptor)));
            N reportLevel = this.parseReportLevel((String)this.getProperty(this.reportLevelDescriptor));
            Number result = Metric.compute(this.metric, (Node)target, (MetricOptions)options);
            if (result != null && ((Comparable)reportLevel).compareTo(result) <= 0) {
                ctx.addViolationWithMessage(target, this.violationMessage(target, result));
            }
        }
        for (Node child : target.children()) {
            this.apply(child, ctx);
        }
    }

    public static abstract class OfDouble
    extends AbstractMetricTestRule<Double> {
        protected OfDouble(Metric<?, Double> metric) {
            super(metric);
        }

        @Override
        protected Double parseReportLevel(String value) {
            return Double.parseDouble(value);
        }

        @Override
        protected Double defaultReportLevel() {
            return 0.0;
        }
    }

    public static abstract class OfInt
    extends AbstractMetricTestRule<Integer> {
        protected OfInt(Metric<?, Integer> metric) {
            super(metric);
        }

        @Override
        protected Integer parseReportLevel(String value) {
            return Integer.parseInt(value);
        }

        @Override
        protected Integer defaultReportLevel() {
            return 0;
        }
    }
}

