/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.ast;

import net.sourceforge.pmd.lang.modelica.ast.AbstractModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaImportClause;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

abstract class AbstractModelicaImportClause
extends AbstractModelicaNode
implements ModelicaImportClause {
    private ResolutionResult<ModelicaDeclaration> importSourcesCache;

    AbstractModelicaImportClause(int id) {
        super(id);
    }

    abstract boolean isQualified();

    protected abstract ResolutionResult<ModelicaDeclaration> getCacheableImportSources(ResolutionState var1, ModelicaScope var2);

    protected abstract void fetchImportedClassesFromSource(ResolutionContext var1, ModelicaDeclaration var2, String var3) throws Watchdog.CountdownException;

    final void resolveSimpleName(ResolutionContext result, String simpleName) throws Watchdog.CountdownException {
        if (this.importSourcesCache == null || this.importSourcesCache.wasTimedOut()) {
            this.importSourcesCache = this.getCacheableImportSources(result.getState(), this.getMostSpecificScope().getParent());
        }
        for (ModelicaDeclaration source : this.importSourcesCache.getBestCandidates()) {
            this.fetchImportedClassesFromSource(result, source, simpleName);
        }
        result.markHidingPoint();
        for (ModelicaDeclaration source : this.importSourcesCache.getHiddenCandidates()) {
            this.fetchImportedClassesFromSource(result, source, simpleName);
        }
    }
}

