/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.ast;

import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.modelica.ast.ASTSimpleName;
import net.sourceforge.pmd.lang.modelica.ast.AbstractModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.Helper;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaVisitor;
import net.sourceforge.pmd.lang.modelica.ast.ResolvableModelicaNode;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.resolver.internal.ResolutionState;

public final class ASTName
extends AbstractModelicaNode
implements ResolvableModelicaNode {
    private String[] nameComponents;
    private ResolutionResult<ResolvableEntity> resolutionCandidates;
    private boolean absolute = false;

    ASTName(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptModelicaVisitor(ModelicaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public void jjtClose() {
        super.jjtClose();
        this.nameComponents = new String[this.getNumChildren()];
        for (int i = 0; i < this.getNumChildren(); ++i) {
            this.nameComponents[i] = ((ASTSimpleName)this.getChild(i)).getName();
        }
    }

    public String getName() {
        String prefix = this.absolute ? "." : "";
        return prefix + this.children(ASTSimpleName.class).toStream().map(ASTSimpleName::getName).collect(Collectors.joining("."));
    }

    void markAbsolute() {
        this.absolute = true;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public CompositeName getCompositeName() {
        return CompositeName.create(this.absolute, this.nameComponents);
    }

    @Override
    public ResolutionResult<ResolvableEntity> getResolutionCandidates() {
        if (this.resolutionCandidates == null) {
            this.resolutionCandidates = this.getMostSpecificScope().safeResolveLexically(ResolvableEntity.class, ResolutionState.forType(), this.getCompositeName());
        }
        return this.resolutionCandidates;
    }

    public String getResolvedTo() {
        return Helper.getResolvedTo(this.getResolutionCandidates());
    }
}

