/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver.internal;

import net.sourceforge.pmd.lang.modelica.resolver.ModelicaComponentDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.internal.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.internal.Watchdog;

public final class ResolutionState {
    private final Watchdog watchdog = new Watchdog(1000);
    private boolean constantsOnly;

    private ResolutionState(boolean constantsOnly) {
        this.constantsOnly = constantsOnly;
    }

    public static ResolutionState forType() {
        return new ResolutionState(true);
    }

    public static ResolutionState forComponentReference() {
        return new ResolutionState(false);
    }

    public void tick() throws Watchdog.CountdownException {
        this.watchdog.decrement();
    }

    public boolean needRecurseInto(ModelicaComponentDeclaration component) {
        return !this.constantsOnly || component.getVariability() == ModelicaComponentDeclaration.ComponentVariability.CONSTANT;
    }

    public ResolutionContext createContext() {
        return new ResolutionContext(this);
    }
}

