/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaBuiltinType;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaSourceFileScope;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.resolver.internal.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.internal.Watchdog;

public final class RootScope
extends AbstractModelicaScope {
    private final List<ModelicaSourceFileScope> sourceFiles = new ArrayList<ModelicaSourceFileScope>();

    void addSourceFile(ModelicaSourceFileScope sourceFile) {
        this.sourceFiles.add(sourceFile);
    }

    void resolveBuiltin(ResolutionContext result, CompositeName name) {
        if (!name.isEmpty() && name.getTail().isEmpty()) {
            String simpleName = name.getHead();
            for (ModelicaBuiltinType.BaseType tpe : ModelicaBuiltinType.BaseType.values()) {
                if (!tpe.getName().equals(simpleName)) continue;
                result.addCandidate(new ModelicaBuiltinType(tpe));
            }
        }
    }

    @Override
    public void resolveLexically(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        CompositeName nameToLookup = "".equals(name.getHead()) ? name.getTail() : name;
        this.resolveBuiltin(result, name);
        for (ModelicaSourceFileScope sourceFile : this.sourceFiles) {
            ResolutionContext tmpContext = result.getState().createContext();
            sourceFile.lookupGlobally(tmpContext, nameToLookup);
            result.accumulate(tmpContext.get(ResolvableEntity.class));
        }
    }

    @Override
    public RootScope getRoot() {
        return this;
    }

    @Override
    public String toString() {
        return "<implicit root scope>";
    }

    @Override
    public String getRepresentation() {
        return "ROOT";
    }
}

