/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AvoidTabCharacterRule
extends AbstractPLSQLRule {
    private static final PropertyDescriptor<Boolean> EACH_LINE = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"eachLine").desc("Whether to report each line with a tab character or only the first line")).defaultValue((Object)false)).build();

    public AvoidTabCharacterRule() {
        this.definePropertyDescriptor(EACH_LINE);
        this.addRuleChainVisit(ASTInput.class);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        boolean eachLine = (Boolean)this.getProperty(EACH_LINE);
        int lineNumber = 1;
        for (Chars line : node.getText().lines()) {
            if (line.indexOf(9, 0) != -1) {
                this.addViolationWithMessage(data, (Node)node, "Tab characters are not allowed. Use spaces for indentation", lineNumber, lineNumber);
                if (!eachLine) break;
            }
            ++lineNumber;
        }
        return data;
    }
}

