/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class LineLengthRule
extends AbstractPLSQLRule {
    private static final PropertyDescriptor<Integer> MAX_LINE_LENGTH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxLineLength").desc("The maximum allowed line length")).defaultValue((Object)80)).require(NumericConstraints.inRange((Number)10, (Number)200))).build();
    private static final PropertyDescriptor<Boolean> EACH_LINE = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"eachLine").desc("Whether to report each line that is longer only the first line")).defaultValue((Object)false)).build();

    public LineLengthRule() {
        this.definePropertyDescriptor(MAX_LINE_LENGTH);
        this.definePropertyDescriptor(EACH_LINE);
        this.addRuleChainVisit(ASTInput.class);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        boolean eachLine = (Boolean)this.getProperty(EACH_LINE);
        int maxLineLength = (Integer)this.getProperty(MAX_LINE_LENGTH);
        int lineNumber = 1;
        for (Chars line : node.getText().lines()) {
            if (line.length() > maxLineLength) {
                this.addViolationWithMessage(data, (Node)node, "The line is too long. Only " + maxLineLength + " characters are allowed.", lineNumber, lineNumber);
                if (!eachLine) break;
            }
            ++lineNumber;
        }
        return data;
    }
}

