/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.ArrayList;
import net.sourceforge.pmd.lang.plsql.ast.ASTCaseStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTCaseWhenClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTElseClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTElsifClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTForStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.plsql.ast.ExecutableCode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitorAdapter;
import net.sourceforge.pmd.lang.plsql.rule.design.NPathComplexityRule;

class NPathComplexityVisitor
extends PLSQLParserVisitorAdapter {
    NPathComplexityVisitor() {
    }

    public int compute(ExecutableCode root) {
        return (Integer)root.jjtAccept(this, null);
    }

    private int complexityMultipleOf(PLSQLNode node, Object data) {
        int npath = 1;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.getChild(i);
            npath *= ((Integer)n.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        return this.complexityMultipleOf(node, data);
    }

    @Override
    public Object visit(ASTProgramUnit node, Object data) {
        return this.complexityMultipleOf(node, data);
    }

    @Override
    public Object visit(ASTTypeMethod node, Object data) {
        return this.complexityMultipleOf(node, data);
    }

    @Override
    public Object visit(ASTTriggerUnit node, Object data) {
        return this.complexityMultipleOf(node, data);
    }

    @Override
    public Object visit(ASTTriggerTimingPointSection node, Object data) {
        return this.complexityMultipleOf(node, data);
    }

    @Override
    public Object visitPlsqlNode(PLSQLNode node, Object data) {
        return this.complexityMultipleOf(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int complexity = 0;
        ArrayList<PLSQLNode> statementChildren = new ArrayList<PLSQLNode>();
        for (int i = 0; i < node.getNumChildren(); ++i) {
            if (((PLSQLNode)node.getChild(i)).getClass() != ASTStatement.class && ((PLSQLNode)node.getChild(i)).getClass() != ASTElsifClause.class && ((PLSQLNode)node.getChild(i)).getClass() != ASTElseClause.class) continue;
            statementChildren.add((PLSQLNode)node.getChild(i));
        }
        for (PLSQLNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        return boolCompIf + complexity;
    }

    @Override
    public Object visit(ASTElsifClause node, Object data) {
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int complexity = 0;
        ArrayList<PLSQLNode> statementChildren = new ArrayList<PLSQLNode>();
        for (int i = 0; i < node.getNumChildren(); ++i) {
            if (((PLSQLNode)node.getChild(i)).getClass() != ASTStatement.class) continue;
            statementChildren.add((PLSQLNode)node.getChild(i));
        }
        for (PLSQLNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        return boolCompIf + complexity;
    }

    @Override
    public Object visit(ASTElseClause node, Object data) {
        int complexity = 0;
        ArrayList<PLSQLNode> statementChildren = new ArrayList<PLSQLNode>();
        for (int i = 0; i < node.getNumChildren(); ++i) {
            if (((PLSQLNode)node.getChild(i)).getClass() != ASTStatement.class) continue;
            statementChildren.add((PLSQLNode)node.getChild(i));
        }
        for (PLSQLNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        return complexity;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathWhile = (Integer)((PLSQLNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompWhile + nPathWhile + 1;
    }

    @Override
    public Object visit(ASTLoopStatement node, Object data) {
        int boolCompDo = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathDo = (Integer)((PLSQLNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompDo + nPathDo + 1;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstDescendantOfType(ASTExpression.class));
        Integer nPathFor = (Integer)((PLSQLNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompFor + nPathFor + 1;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        ASTExpression expr = (ASTExpression)node.getFirstChildOfType(ASTExpression.class);
        if (expr == null) {
            return 1;
        }
        int boolCompReturn = NPathComplexityRule.sumExpressionComplexity(expr);
        int conditionalExpressionComplexity = this.complexityMultipleOf(expr, data);
        if (conditionalExpressionComplexity > 1) {
            boolCompReturn += conditionalExpressionComplexity;
        }
        if (boolCompReturn > 0) {
            return boolCompReturn;
        }
        return 1;
    }

    @Override
    public Object visit(ASTCaseWhenClause node, Object data) {
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int npath = 1;
        int caseRange = 0;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.getChild(i);
            Integer complexity = (Integer)n.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        return boolCompSwitch + (npath += caseRange);
    }

    @Override
    public Object visit(ASTCaseStatement node, Object data) {
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int npath = 0;
        int caseRange = 0;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.getChild(i);
            Integer complexity = (Integer)n.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        return boolCompSwitch + (npath += caseRange);
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        return 1;
    }
}

