/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.List;
import net.sourceforge.pmd.lang.plsql.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTExpression;
import net.sourceforge.pmd.lang.plsql.ast.AbstractPLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.ExecutableCode;
import net.sourceforge.pmd.lang.plsql.rule.design.AbstractCounterCheckRule;
import net.sourceforge.pmd.lang.plsql.rule.design.NPathComplexityVisitor;

public class NPathComplexityRule
extends AbstractCounterCheckRule<ExecutableCode> {
    public NPathComplexityRule() {
        super(ExecutableCode.class);
    }

    @Override
    protected int defaultReportLevel() {
        return 200;
    }

    @Override
    protected int getMetric(ExecutableCode node) {
        return new NPathComplexityVisitor().compute(node);
    }

    @Override
    protected Object[] getViolationParameters(ExecutableCode node, int metric) {
        return new Object[]{node.getMethodName(), metric};
    }

    static int sumExpressionComplexity(ASTExpression expr) {
        if (expr == null) {
            return 0;
        }
        List andNodes = expr.descendants(ASTConditionalAndExpression.class).toList();
        List orNodes = expr.descendants(ASTConditionalOrExpression.class).toList();
        int children = 0;
        for (AbstractPLSQLNode element : orNodes) {
            children += element.getNumChildren();
            --children;
        }
        for (AbstractPLSQLNode element : andNodes) {
            children += element.getNumChildren();
            --children;
        }
        return children;
    }
}

