/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.ast;

import java.util.Locale;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.JjtreeParserAdapter;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserImpl;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLTokenKinds;
import net.sourceforge.pmd.lang.plsql.symboltable.SymbolFacade;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PLSQLParser
extends JjtreeParserAdapter<ASTInput> {
    private static final String[] STRING_LITERAL_IMAGES_EXTRA = new String[PLSQLTokenKinds.TOKEN_NAMES.size()];
    static final JavaccTokenDocument.TokenDocumentBehavior TOKEN_BEHAVIOR;

    protected JavaccTokenDocument.TokenDocumentBehavior tokenBehavior() {
        return TOKEN_BEHAVIOR;
    }

    protected ASTInput parseImpl(CharStream cs, Parser.ParserTask task) throws ParseException {
        ASTInput root = new PLSQLParserImpl(cs).Input().addTaskInfo(task);
        TimeTracker.bench((String)"PLSQL symbols", () -> SymbolFacade.process(root));
        return root;
    }

    static {
        for (int i = 0; i < PLSQLTokenKinds.TOKEN_NAMES.size(); ++i) {
            String image = PLSQLTokenKinds.TOKEN_NAMES.get(i);
            if (!image.startsWith("\"") || !image.endsWith("\"")) continue;
            PLSQLParser.STRING_LITERAL_IMAGES_EXTRA[i] = image = image.substring(1, image.length() - 1);
        }
        TOKEN_BEHAVIOR = new JavaccTokenDocument.TokenDocumentBehavior(PLSQLTokenKinds.TOKEN_NAMES){

            public JavaccToken createToken(JavaccTokenDocument self, int kind, CharStream cs, @Nullable String image) {
                if (image == null) {
                    image = STRING_LITERAL_IMAGES_EXTRA[kind];
                }
                if (image == null) {
                    Chars imageCs = cs.getTokenImageCs();
                    image = kind == 469 && imageCs.charAt(0) == '\"' ? imageCs.substring(1, imageCs.length() - 1) : imageCs.toString();
                    if (kind != 475 && kind != 492 && kind != 477) {
                        image = image.toUpperCase(Locale.ROOT);
                    }
                }
                return super.createToken(self, kind, cs, image);
            }
        };
    }
}

