/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageBody;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ExecutableCode;
import net.sourceforge.pmd.lang.plsql.ast.OracleObject;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.AbstractPLSQLRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.rule.internal.CommonPropertyDescriptors;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractCounterCheckRule<T extends PLSQLNode>
extends AbstractPLSQLRule {
    private final Class<T> nodeType;
    private final PropertyDescriptor<Integer> reportLevel = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)CommonPropertyDescriptors.reportLevelProperty().desc("Threshold above which a node is reported")).require(NumericConstraints.positive())).defaultValue((Object)this.defaultReportLevel())).build();

    AbstractCounterCheckRule(Class<T> nodeType) {
        this.nodeType = nodeType;
        this.definePropertyDescriptor(this.reportLevel);
    }

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        if (!Modifier.isAbstract(this.nodeType.getModifiers()) && !this.nodeType.isInterface()) {
            return RuleTargetSelector.forTypes(this.nodeType, (Class[])new Class[0]);
        }
        return RuleTargetSelector.forTypes(this.determineRulechainVisits(this.nodeType));
    }

    private Collection<Class<? extends Node>> determineRulechainVisits(Class<T> abstractNodeType) {
        HashSet<Class<? extends Node>> classes = new HashSet<Class<? extends Node>>();
        if (abstractNodeType == OracleObject.class) {
            classes.add(ASTPackageBody.class);
            classes.add(ASTPackageSpecification.class);
            classes.add(ASTProgramUnit.class);
            classes.add(ASTTriggerUnit.class);
            classes.add(ASTTypeSpecification.class);
        } else if (abstractNodeType == ExecutableCode.class) {
            classes.add(ASTMethodDeclaration.class);
            classes.add(ASTProgramUnit.class);
            classes.add(ASTTriggerTimingPointSection.class);
            classes.add(ASTTriggerUnit.class);
            classes.add(ASTTypeMethod.class);
        }
        return classes;
    }

    protected abstract int defaultReportLevel();

    protected boolean isIgnored(T node) {
        return false;
    }

    protected Object[] getViolationParameters(T node, int metric) {
        return new Object[]{metric};
    }

    protected abstract int getMetric(T var1);

    @Override
    public Object visitPlsqlNode(PLSQLNode node, Object data) {
        int metric;
        PLSQLNode t = node;
        if (!this.isIgnored(t) && (metric = this.getMetric(t)) >= (Integer)this.getProperty(this.reportLevel)) {
            this.asCtx(data).addViolation((Node)node, this.getViolationParameters(t, metric));
        }
        return data;
    }

    static abstract class AbstractLineLengthCheckRule<T extends PLSQLNode>
    extends AbstractCounterCheckRule<T> {
        AbstractLineLengthCheckRule(Class<T> nodeType) {
            super(nodeType);
        }

        @Override
        protected int getMetric(T node) {
            return node.getEndLine() - node.getBeginLine();
        }
    }
}

