/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNameDeclaration
extends AbstractNameDeclaration {
    private static final Logger LOG = LoggerFactory.getLogger(MethodNameDeclaration.class);

    public MethodNameDeclaration(ASTMethodDeclarator node) {
        super((ScopedNode)node);
    }

    public MethodNameDeclaration(ASTTriggerTimingPointSection node) {
        super((ScopedNode)node);
    }

    public int getParameterCount() {
        return ((ASTMethodDeclarator)this.node).getParameterCount();
    }

    public boolean isVarargs() {
        return false;
    }

    public ASTMethodDeclarator getMethodNameDeclaratorNode() {
        return (ASTMethodDeclarator)this.node;
    }

    public String getParameterDisplaySignature() {
        StringBuilder sb = new StringBuilder("(");
        ASTFormalParameters params = (ASTFormalParameters)this.node.getChild(0);
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            ASTFormalParameter p = (ASTFormalParameter)params.getChild(i);
            sb.append(p.getTypeNode().getTypeImage());
            sb.append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodNameDeclaration)) {
            return false;
        }
        MethodNameDeclaration other = (MethodNameDeclaration)((Object)o);
        if (!other.node.getImage().equals(this.node.getImage())) {
            return false;
        }
        if (((ASTMethodDeclarator)other.node).getParameterCount() != ((ASTMethodDeclarator)this.node).getParameterCount()) {
            return false;
        }
        ASTFormalParameters myParams = (ASTFormalParameters)this.node.descendants(ASTFormalParameters.class).first();
        ASTFormalParameters otherParams = (ASTFormalParameters)other.node.descendants(ASTFormalParameters.class).first();
        for (int i = 0; i < ((ASTMethodDeclarator)this.node).getParameterCount(); ++i) {
            String otherTypeImg;
            ASTFormalParameter myParam = (ASTFormalParameter)myParams.getChild(i);
            ASTFormalParameter otherParam = (ASTFormalParameter)otherParams.getChild(i);
            Node myTypeNode = myParam.getTypeNode().getChild(0);
            Node otherTypeNode = otherParam.getTypeNode().getChild(0);
            if (myTypeNode.getClass() != otherTypeNode.getClass()) {
                return false;
            }
            String myTypeImg = myTypeNode.getChild(0).getImage();
            if (myTypeImg.equals(otherTypeImg = otherTypeNode.getChild(0).getImage())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        try {
            return this.node.hashCode();
        }
        catch (Exception e) {
            LOG.trace("MethodNameDeclaration problem for {} of class {} => {}/{}", new Object[]{this.node, this.node.getClass().getCanonicalName(), this.node.getBeginLine(), this.node.getBeginColumn()});
            return 0;
        }
    }

    public String toString() {
        return this.node.toString();
    }
}

