/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.plsql.ast.PlsqlVisitorBase;
import net.sourceforge.pmd.lang.plsql.symboltable.NameFinder;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.plsql.symboltable.Search;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccurrenceFinder
extends PlsqlVisitorBase<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(OccurrenceFinder.class);

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        NameFinder nameFinder = new NameFinder(node);
        HashSet<Object> declarations = new HashSet<Object>();
        List<PLSQLNameOccurrence> names = nameFinder.getNames();
        for (PLSQLNameOccurrence occ : names) {
            Search search = new Search(occ);
            if (declarations.isEmpty()) {
                search.execute();
                declarations.addAll(search.getResult());
                if (!declarations.isEmpty()) continue;
                break;
            }
            HashSet<NameDeclaration> additionalDeclarations = new HashSet<NameDeclaration>();
            for (NameDeclaration nameDeclaration : declarations) {
                Scope scope = nameDeclaration.getScope();
                if (null == scope) {
                    LOG.trace("NameOccurrence has no Scope:{}=>{}", (Object)nameDeclaration.getClass().getCanonicalName(), (Object)nameDeclaration.getImage());
                    break;
                }
                search.execute(scope);
                Set<NameDeclaration> found = search.getResult();
                additionalDeclarations.addAll(found);
                if (!found.isEmpty()) continue;
                break;
            }
            declarations.addAll(additionalDeclarations);
        }
        return super.visit(node, data);
    }
}

