/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.lang.plsql.ast.ASTBlock;
import net.sourceforge.pmd.lang.plsql.ast.ASTDeclarativeUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTForAllStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTForStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTID;
import net.sourceforge.pmd.lang.plsql.ast.ASTInput;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.plsql.ast.ASTObjectDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTObjectNameDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageBody;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeSpecification;
import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantDeclaratorId;
import net.sourceforge.pmd.lang.plsql.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PlsqlVisitorBase;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassScope;
import net.sourceforge.pmd.lang.plsql.symboltable.LocalScope;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.plsql.symboltable.MethodScope;
import net.sourceforge.pmd.lang.plsql.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.plsql.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeAndDeclarationFinder
extends PlsqlVisitorBase<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ScopeAndDeclarationFinder.class);
    private Deque<Scope> scopes = new ArrayDeque<Scope>();

    private void addScope(Scope newScope, PLSQLNode node) {
        newScope.setParent(this.scopes.peek());
        this.scopes.push(newScope);
        InternalApiBridge.setScope(node, newScope);
    }

    private void createLocalScope(PLSQLNode node) {
        this.addScope((Scope)new LocalScope(), node);
    }

    private void createMethodScope(PLSQLNode node) {
        this.addScope((Scope)new MethodScope(node), node);
    }

    private void createClassScope(PLSQLNode node) {
        if (node instanceof ASTDeclarativeUnit) {
            this.addScope((Scope)new ClassScope(), node);
        } else {
            this.addScope((Scope)new ClassScope(node.getImage()), node);
        }
    }

    private void createSourceFileScope(ASTInput node) {
        Object n = null;
        SourceFileScope scope = n != null ? new SourceFileScope(((PLSQLNode)n.getChild(0)).getImage()) : new SourceFileScope();
        this.scopes.push((Scope)scope);
        InternalApiBridge.setScope(node, (Scope)scope);
    }

    @Override
    public Object visit(ASTInput node, Object data) {
        this.createSourceFileScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTPackageSpecification node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.getParent()).getScope();
        s.addDeclaration((NameDeclaration)new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTPackageBody node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.getParent()).getScope();
        s.addDeclaration((NameDeclaration)new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTypeSpecification node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.getParent()).getScope();
        s.addDeclaration((NameDeclaration)new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTriggerUnit node, Object data) {
        this.createClassScope(node);
        Scope s = ((PLSQLNode)node.getParent()).getScope();
        s.addDeclaration((NameDeclaration)new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTriggerTimingPointSection node, Object data) {
        this.createMethodScope(node);
        ((ClassScope)node.getScope().getEnclosingScope(ClassScope.class)).addDeclaration((NameDeclaration)new MethodNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTObjectDeclaration node, Object data) {
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    private Object visitMethodLike(PLSQLNode node, Object data) {
        block2: {
            this.createMethodScope(node);
            ASTMethodDeclarator md = (ASTMethodDeclarator)node.firstChild(ASTMethodDeclarator.class);
            try {
                ((ClassScope)node.getScope().getEnclosingScope(ClassScope.class)).addDeclaration((NameDeclaration)new MethodNameDeclaration(md));
            }
            catch (Exception e) {
                LOG.trace("ProgramUnit getEnclosingClassScope Exception string=\"{}\"", (Object)e.getMessage());
                if (!"getEnclosingClassScope() called on SourceFileScope".equals(e.getMessage())) break block2;
                LOG.trace("ClassScope skipped for Schema-level method: methodName={}; Image={}", (Object)md.getImage(), (Object)node.getImage());
                ASTObjectNameDeclaration on = (ASTObjectNameDeclaration)md.firstChild(ASTObjectNameDeclaration.class);
                if (1 >= on.getNumChildren()) break block2;
                ASTID schemaName = (ASTID)on.firstChild(ASTID.class);
                LOG.trace("SchemaName for Schema-level method: methodName={}; Image={} is {}", new Object[]{md.getImage(), node.getImage(), schemaName.getImage()});
            }
        }
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTypeMethod node, Object data) {
        return this.visitMethodLike(node, data);
    }

    @Override
    public Object visit(ASTProgramUnit node, Object data) {
        return this.visitMethodLike(node, data);
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTForAllStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableOrConstantDeclaratorId node, Object data) {
        VariableNameDeclaration decl = new VariableNameDeclaration(node);
        node.getScope().addDeclaration((NameDeclaration)decl);
        InternalApiBridge.setNameDeclaration(node, (NameDeclaration)decl);
        return super.visit(node, data);
    }

    private void cont(PLSQLNode node) {
        super.visitPlsqlNode(node, null);
        this.scopes.pop();
    }
}

