/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search {
    private static final Logger LOG = LoggerFactory.getLogger(Search.class);
    private PLSQLNameOccurrence occ;
    private Set<NameDeclaration> declarations = new HashSet<NameDeclaration>();

    public Search(PLSQLNameOccurrence occ) {
        LOG.trace("new search for {} {}", (Object)(occ.isMethodOrConstructorInvocation() ? "method" : "variable"), (Object)occ);
        this.occ = occ;
    }

    public void execute() {
        Set<NameDeclaration> found = this.searchUpward(this.occ, this.occ.getLocation().getScope());
        LOG.trace("found {}", found);
        this.declarations.addAll(found);
    }

    public void execute(Scope startingScope) {
        Set<NameDeclaration> found = this.searchUpward(this.occ, startingScope);
        LOG.trace("found {}", found);
        this.declarations.addAll(found);
    }

    public Set<NameDeclaration> getResult() {
        return this.declarations;
    }

    private Set<NameDeclaration> searchUpward(PLSQLNameOccurrence nameOccurrence, Scope scope) {
        LOG.trace("checking scope {} for name occurrence {}", (Object)scope, (Object)nameOccurrence);
        if (!scope.contains((NameOccurrence)nameOccurrence) && scope.getParent() != null) {
            LOG.trace("moving up fm {} to {}", (Object)scope, (Object)scope.getParent());
            return this.searchUpward(nameOccurrence, scope.getParent());
        }
        if (scope.contains((NameOccurrence)nameOccurrence)) {
            LOG.trace("found it!");
            return scope.addNameOccurrence((NameOccurrence)nameOccurrence);
        }
        return new HashSet<NameDeclaration>();
    }
}

