/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.scala.cpd;

import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import scala.meta.tokens.Token;

public class ScalaTokenAdapter
implements GenericToken<ScalaTokenAdapter> {
    private final Token token;
    private final TextDocument textDocument;
    private final ScalaTokenAdapter previousComment;

    ScalaTokenAdapter(Token token, TextDocument textDocument, ScalaTokenAdapter comment) {
        this.token = token;
        this.textDocument = textDocument;
        this.previousComment = comment;
    }

    public ScalaTokenAdapter getNext() {
        throw new UnsupportedOperationException();
    }

    public ScalaTokenAdapter getPreviousComment() {
        return this.previousComment;
    }

    public String getImage() {
        return this.token.text();
    }

    public Chars getImageCs() {
        return this.textDocument.sliceTranslatedText(this.getRegion());
    }

    public TextRegion getRegion() {
        return TextRegion.fromBothOffsets((int)this.token.pos().start(), (int)this.token.pos().end());
    }

    public FileLocation getReportLocation() {
        return this.textDocument.toLocation(this.getRegion());
    }

    public boolean isEof() {
        return this.token instanceof Token.EOF;
    }

    public int getKind() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ScalaTokenAdapter{token=" + this.token + ", previousComment=" + this.previousComment + "}";
    }
}

