/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.swift.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.swift.AbstractSwiftRule;
import net.sourceforge.pmd.lang.swift.ast.SwiftParser;
import net.sourceforge.pmd.lang.swift.ast.SwiftVisitor;
import net.sourceforge.pmd.lang.swift.ast.SwiftVisitorBase;

public class UnavailableFunctionRule
extends AbstractSwiftRule {
    private static final String AVAILABLE_UNAVAILABLE = "@available(*,unavailable)";
    private static final String FATAL_ERROR = "fatalError";

    public UnavailableFunctionRule() {
        this.addRuleChainVisit(SwiftParser.SwFunctionDeclaration.class);
        this.addRuleChainVisit(SwiftParser.SwInitializerDeclaration.class);
    }

    @Override
    public SwiftVisitor<RuleContext, ?> buildVisitor() {
        return new SwiftVisitorBase<RuleContext, Void>(){

            @Override
            public Void visitFunctionDeclaration(SwiftParser.SwFunctionDeclaration ctx, RuleContext ruleCtx) {
                SwiftParser.SwAttributes attributes;
                if (ctx == null) {
                    return null;
                }
                if (this.shouldIncludeUnavailableModifier(ctx.functionBody().codeBlock()) && ((attributes = ctx.functionHead().attributes()) == null || !this.hasUnavailableModifier(attributes.attribute()))) {
                    UnavailableFunctionRule.this.addViolation(ruleCtx, (Node)ctx);
                }
                return null;
            }

            @Override
            public Void visitInitializerDeclaration(SwiftParser.SwInitializerDeclaration ctx, RuleContext ruleCtx) {
                SwiftParser.SwAttributes attributes;
                if (ctx == null) {
                    return null;
                }
                if (this.shouldIncludeUnavailableModifier(ctx.initializerBody().codeBlock()) && ((attributes = ctx.initializerHead().attributes()) == null || !this.hasUnavailableModifier(attributes.attribute()))) {
                    UnavailableFunctionRule.this.addViolation(ruleCtx, (Node)ctx);
                }
                return null;
            }

            private boolean shouldIncludeUnavailableModifier(SwiftParser.SwCodeBlock ctx) {
                if (ctx == null || ctx.statements() == null) {
                    return false;
                }
                List<SwiftParser.SwStatement> statements = ctx.statements().statement();
                return statements.size() == 1 && UnavailableFunctionRule.FATAL_ERROR.equals(statements.get(0).getFirstAntlrToken().getText());
            }

            private boolean hasUnavailableModifier(List<SwiftParser.SwAttribute> attributes) {
                return attributes.stream().anyMatch(atr -> UnavailableFunctionRule.AVAILABLE_UNAVAILABLE.equals(atr.joinTokenText()));
            }
        };
    }
}

