/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test.schema;

import com.github.oowekyala.ooxml.DomUtils;
import com.github.oowekyala.ooxml.messages.PositionedXmlDoc;
import com.github.oowekyala.ooxml.messages.XmlPosition;
import com.github.oowekyala.ooxml.messages.XmlPositioner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.test.schema.RuleTestCollection;
import net.sourceforge.pmd.test.schema.RuleTestDescriptor;
import net.sourceforge.pmd.test.schema.TestSchemaParser;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BaseTestParserImpl {
    BaseTestParserImpl() {
    }

    public RuleTestCollection parseDocument(Rule rule, PositionedXmlDoc positionedXmlDoc, TestSchemaParser.PmdXmlReporter err) {
        Document doc = positionedXmlDoc.getDocument();
        Element root = doc.getDocumentElement();
        Map<String, Element> codeFragments = this.parseCodeFragments(err, root);
        HashSet<String> usedFragments = new HashSet<String>();
        List testCodes = DomUtils.childrenNamed((Element)root, (String)"test-code");
        RuleTestCollection result = new RuleTestCollection();
        for (int i = 0; i < testCodes.size(); ++i) {
            RuleTestDescriptor descriptor = new RuleTestDescriptor(i, rule.deepCopy());
            try (TestSchemaParser.PmdXmlReporter errScope = err.newScope();){
                this.parseSingleTest((Element)testCodes.get(i), descriptor, codeFragments, usedFragments, positionedXmlDoc.getPositioner(), errScope);
                if (errScope.hasError()) continue;
                result.addTest(descriptor);
                continue;
            }
        }
        codeFragments.keySet().removeAll(usedFragments);
        codeFragments.forEach((id, node) -> ((TestSchemaParser.Reporter)err.at((Node)node)).warn("Unused code fragment", new Object[0]));
        return result;
    }

    private Map<String, Element> parseCodeFragments(TestSchemaParser.PmdXmlReporter err, Element root) {
        HashMap<String, Element> codeFragments = new HashMap<String, Element>();
        for (Element node : DomUtils.childrenNamed((Element)root, (String)"code-fragment")) {
            Element prev;
            Attr id = this.getRequiredAttribute("id", node, err);
            if (id == null || (prev = codeFragments.put(id.getValue(), node)) == null) continue;
            ((TestSchemaParser.Reporter)err.at(prev)).error("Fragment with duplicate id ''{0}'' is ignored", id.getValue());
        }
        return codeFragments;
    }

    private void parseSingleTest(Element testCode, RuleTestDescriptor descriptor, Map<String, Element> fragments, Set<String> usedFragments, XmlPositioner xmlPositioner, TestSchemaParser.PmdXmlReporter err) {
        String description = this.getSingleChildText(testCode, "description", true, err);
        if (description == null) {
            return;
        }
        descriptor.setDescription(description);
        this.parseBoolAttribute(testCode, "reinitializeRule", true, err, "Attribute 'reinitializeRule' is deprecated and ignored, assumed true");
        this.parseBoolAttribute(testCode, "useAuxClasspath", true, err, "Attribute 'useAuxClasspath' is deprecated and ignored, assumed true");
        boolean disabled = this.parseBoolAttribute(testCode, "disabled", false, err, null) | !this.parseBoolAttribute(testCode, "regressionTest", true, err, "Attribute ''regressionTest'' is deprecated, use ''disabled'' with inverted value");
        descriptor.setDisabled(disabled);
        boolean focused = this.parseBoolAttribute(testCode, "focused", false, err, "Attribute focused is used, do not forget to remove it when checking in sources");
        descriptor.setFocused(focused);
        Properties properties = this.parseRuleProperties(testCode, (PropertySource)descriptor.getRule(), err);
        descriptor.getProperties().putAll((Map<?, ?>)properties);
        this.parseExpectedProblems(testCode, descriptor, err);
        String code = this.getTestCode(testCode, fragments, usedFragments, err);
        if (code == null) {
            return;
        }
        descriptor.setCode(code);
        LanguageVersion lversion = this.parseLanguageVersion(testCode, err);
        if (lversion != null) {
            descriptor.setLanguageVersion(lversion);
        }
        XmlPosition startPosition = xmlPositioner.startPositionOf((Node)testCode);
        descriptor.setLineNumber(startPosition.getLine());
    }

    private void parseExpectedProblems(Element testCode, RuleTestDescriptor descriptor, TestSchemaParser.PmdXmlReporter err) {
        Element expectedProblemsNode = this.getSingleChild(testCode, "expected-problems", true, err);
        if (expectedProblemsNode == null) {
            return;
        }
        int expectedProblems = Integer.parseInt(BaseTestParserImpl.parseTextNode(expectedProblemsNode));
        List<String> expectedMessages = Collections.emptyList();
        Element messagesNode = this.getSingleChild(testCode, "expected-messages", false, err);
        if (messagesNode != null) {
            expectedMessages = new ArrayList();
            List messageNodes = DomUtils.childrenNamed((Element)messagesNode, (String)"message");
            if (messageNodes.size() != expectedProblems) {
                ((TestSchemaParser.Reporter)err.at(expectedProblemsNode)).error("Number of ''expected-messages'' ({0}) does not match", messageNodes.size());
                return;
            }
            for (Node message : messageNodes) {
                expectedMessages.add(BaseTestParserImpl.parseTextNode(message));
            }
        }
        List<Integer> expectedLineNumbers = Collections.emptyList();
        Element lineNumbers = this.getSingleChild(testCode, "expected-linenumbers", false, err);
        if (lineNumbers != null) {
            expectedLineNumbers = new ArrayList();
            String[] linenos = BaseTestParserImpl.parseTextNode(lineNumbers).split(",");
            if (linenos.length != expectedProblems) {
                ((TestSchemaParser.Reporter)err.at(expectedProblemsNode)).error("Number of ''expected-linenumbers'' ({0}) does not match", linenos.length);
                return;
            }
            for (String num : linenos) {
                expectedLineNumbers.add(Integer.valueOf(num.trim()));
            }
        }
        descriptor.recordExpectedViolations(expectedProblems, expectedLineNumbers, expectedMessages);
    }

    private String getTestCode(Element testCode, Map<String, Element> fragments, Set<String> usedFragments, TestSchemaParser.PmdXmlReporter err) {
        String code = this.getSingleChildText(testCode, "code", false, err);
        if (code == null) {
            List coderefs = DomUtils.childrenNamed((Element)testCode, (String)"code-ref");
            if (coderefs.isEmpty()) {
                throw new RuntimeException("Required tag is missing from the test-xml. Supply either a code or a code-ref tag");
            }
            Element coderef = (Element)coderefs.get(0);
            Attr id = this.getRequiredAttribute("id", coderef, err);
            if (id == null) {
                return null;
            }
            Element fragment = fragments.get(id.getValue());
            if (fragment == null) {
                ((TestSchemaParser.Reporter)err.at(id)).error("Unknown id, known IDs are {0}", fragments.keySet());
                return null;
            }
            usedFragments.add(id.getValue());
            code = BaseTestParserImpl.parseTextNodeNoTrim(fragment);
            code = code.trim();
        }
        return code;
    }

    private LanguageVersion parseLanguageVersion(Element testCode, TestSchemaParser.PmdXmlReporter err) {
        Element sourceTypeNode = this.getSingleChild(testCode, "source-type", false, err);
        if (sourceTypeNode == null) {
            return null;
        }
        String languageVersionString = BaseTestParserImpl.parseTextNode(sourceTypeNode);
        LanguageVersion languageVersion = BaseTestParserImpl.parseSourceType(languageVersionString);
        if (languageVersion != null) {
            return languageVersion;
        }
        ((TestSchemaParser.Reporter)err.at(sourceTypeNode)).error("Unknown language version ''{0}''", languageVersionString);
        return null;
    }

    private static LanguageVersion parseSourceType(String terseNameAndVersion) {
        String terseName;
        String version;
        if (terseNameAndVersion.contains(" ")) {
            version = StringUtils.trimToNull((String)terseNameAndVersion.substring(terseNameAndVersion.lastIndexOf(32) + 1));
            terseName = terseNameAndVersion.substring(0, terseNameAndVersion.lastIndexOf(32));
        } else {
            version = null;
            terseName = terseNameAndVersion;
        }
        Language language = LanguageRegistry.findLanguageByTerseName((String)terseName);
        if (language != null) {
            if (version == null) {
                return language.getDefaultVersion();
            }
            return language.getVersion(version);
        }
        return null;
    }

    private Properties parseRuleProperties(Element testCode, PropertySource knownProps, TestSchemaParser.PmdXmlReporter err) {
        Properties properties = new Properties();
        for (Element ruleProperty : DomUtils.childrenNamed((Element)testCode, (String)"rule-property")) {
            Attr nameAttr = this.getRequiredAttribute("name", ruleProperty, err);
            if (nameAttr == null) continue;
            String propertyName = nameAttr.getNodeValue();
            if (knownProps.getPropertyDescriptor(propertyName) == null) {
                String knownNames = knownProps.getPropertyDescriptors().stream().map(PropertyDescriptor::name).collect(Collectors.joining(", "));
                ((TestSchemaParser.Reporter)err.at(nameAttr)).error("Unknown property, known property names are {0}", knownNames);
                continue;
            }
            properties.setProperty(propertyName, BaseTestParserImpl.parseTextNode(ruleProperty));
        }
        return properties;
    }

    private Attr getRequiredAttribute(String name, Element ruleProperty, TestSchemaParser.PmdXmlReporter err) {
        Attr nameAttr = (Attr)ruleProperty.getAttributes().getNamedItem(name);
        if (nameAttr == null) {
            ((TestSchemaParser.Reporter)err.at(ruleProperty)).error("Missing ''{0}'' attribute", name);
            return null;
        }
        return nameAttr;
    }

    private boolean parseBoolAttribute(Element testCode, String attrName, boolean defaultValue, TestSchemaParser.PmdXmlReporter err, String deprecationMessage) {
        Attr attrNode = testCode.getAttributeNode(attrName);
        if (attrNode != null) {
            if (deprecationMessage != null) {
                ((TestSchemaParser.Reporter)err.at(attrNode)).warn(deprecationMessage, new Object[0]);
            }
            return Boolean.parseBoolean(attrNode.getNodeValue());
        }
        return defaultValue;
    }

    private String getSingleChildText(Element parentElm, String nodeName, boolean required, TestSchemaParser.PmdXmlReporter err) {
        Element node = this.getSingleChild(parentElm, nodeName, required, err);
        if (node == null) {
            return null;
        }
        return BaseTestParserImpl.parseTextNode(node);
    }

    private Element getSingleChild(Element parentElm, String nodeName, boolean required, TestSchemaParser.PmdXmlReporter err) {
        List nodes = DomUtils.childrenNamed((Element)parentElm, (String)nodeName);
        if (nodes.isEmpty()) {
            if (required) {
                ((TestSchemaParser.Reporter)err.at(parentElm)).error("Required child ''{0}'' is missing", nodeName);
            }
            return null;
        }
        if (nodes.size() > 1) {
            ((TestSchemaParser.Reporter)err.at((Node)nodes.get(1))).error("Duplicate tag ''{0}'' is ignored", nodeName);
        }
        return (Element)nodes.get(0);
    }

    private static String parseTextNode(Node exampleNode) {
        return BaseTestParserImpl.parseTextNodeNoTrim(exampleNode).trim();
    }

    private static String parseTextNodeNoTrim(Node exampleNode) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < exampleNode.getChildNodes().getLength(); ++i) {
            Node node = exampleNode.getChildNodes().item(i);
            if (node.getNodeType() != 4 && node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    static class ParserV1
    extends BaseTestParserImpl {
        ParserV1() {
        }
    }
}

