/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test.schema;

import com.github.oowekyala.ooxml.messages.NiceXmlMessageSpec;
import com.github.oowekyala.ooxml.messages.OoxmlFacade;
import com.github.oowekyala.ooxml.messages.PositionedXmlDoc;
import com.github.oowekyala.ooxml.messages.PrintStreamMessageHandler;
import com.github.oowekyala.ooxml.messages.XmlException;
import com.github.oowekyala.ooxml.messages.XmlMessageHandler;
import com.github.oowekyala.ooxml.messages.XmlMessageReporter;
import com.github.oowekyala.ooxml.messages.XmlMessageReporterBase;
import com.github.oowekyala.ooxml.messages.XmlPosition;
import com.github.oowekyala.ooxml.messages.XmlPositioner;
import com.github.oowekyala.ooxml.messages.XmlSeverity;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.test.schema.RuleTestCollection;
import net.sourceforge.pmd.test.schema.TestSchemaVersion;
import org.xml.sax.InputSource;

@Experimental
public class TestSchemaParser {
    private final TestSchemaVersion version;

    TestSchemaParser(TestSchemaVersion version) {
        this.version = version;
    }

    public TestSchemaParser() {
        this(TestSchemaVersion.V1);
    }

    public RuleTestCollection parse(Rule rule, InputSource inputSource) throws IOException, XmlException {
        OoxmlFacade ooxml = new OoxmlFacade().withPrinter((XmlMessageHandler)new PrintStreamMessageHandler(System.err));
        PositionedXmlDoc doc = ooxml.parse(this.newDocumentBuilder(), inputSource);
        try (PmdXmlReporterImpl err = new PmdXmlReporterImpl(ooxml, doc.getPositioner());){
            RuleTestCollection collection = this.version.getParserImpl().parseDocument(rule, doc, err);
            if (err.hasError()) {
                throw new IllegalStateException("Errors were encountered while parsing XML tests");
            }
            RuleTestCollection ruleTestCollection = collection;
            return ruleTestCollection;
        }
    }

    private DocumentBuilder newDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    static final class Reporter {
        private final XmlPosition position;
        private final XmlPositioner positioner;
        private final OoxmlFacade ooxml;
        private final Consumer<XmlException> handler;

        private Reporter(XmlPosition position, XmlPositioner positioner, OoxmlFacade ooxml, Consumer<XmlException> handler) {
            this.position = position;
            this.positioner = positioner;
            this.ooxml = ooxml;
            this.handler = handler;
        }

        public void warn(String messageFormat, Object ... args) {
            this.reportImpl(XmlSeverity.WARNING, MessageFormat.format(messageFormat, args));
        }

        public void error(String messageFormat, Object ... args) {
            this.reportImpl(XmlSeverity.ERROR, MessageFormat.format(messageFormat, args));
        }

        private void reportImpl(XmlSeverity severity, String formattedMessage) {
            NiceXmlMessageSpec spec = new NiceXmlMessageSpec(this.position, formattedMessage).withSeverity(severity);
            String fullMessage = this.ooxml.getFormatter().formatSpec(this.ooxml, spec, this.positioner);
            XmlException ex = new XmlException(spec, fullMessage);
            this.handler.accept(ex);
        }
    }

    private static class PmdXmlReporterImpl
    extends XmlMessageReporterBase<Reporter>
    implements PmdXmlReporter {
        private boolean hasError;

        protected PmdXmlReporterImpl(OoxmlFacade ooxml, XmlPositioner positioner) {
            super(ooxml, positioner);
        }

        protected Reporter create2ndStage(XmlPosition position, XmlPositioner positioner) {
            return new Reporter(position, positioner, this.ooxml, this::handleEx);
        }

        protected void handleEx(XmlException e) {
            super.handleEx(e);
            this.hasError |= e.getSeverity() == XmlSeverity.ERROR;
        }

        @Override
        public PmdXmlReporter newScope() {
            return new PmdXmlReporterImpl(this.ooxml, this.positioner){

                @Override
                protected void handleEx(XmlException e) {
                    super.handleEx(e);
                    hasError = (byte)(hasError | (this.hasError() ? 1 : 0));
                }
            };
        }

        @Override
        public boolean hasError() {
            return this.hasError;
        }
    }

    static interface PmdXmlReporter
    extends XmlMessageReporter<Reporter> {
        public boolean hasError();

        public PmdXmlReporter newScope();
    }
}

