/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test.schema;

import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.Rule;

public class RuleTestDescriptor {
    private boolean disabled;
    private boolean focused;
    private String description;
    private LanguageVersion languageVersion;
    private final Properties properties = new Properties();
    private final int index;
    private final Rule rule;
    private String code;
    private int expectedProblems;
    private List<Integer> expectedLineNumbers;
    private List<Integer> expectedEndLineNumbers;
    private List<String> expectedMessages;
    private int lineNumber;

    public RuleTestDescriptor(int index, Rule rule) {
        this.index = index;
        this.rule = rule;
        this.languageVersion = rule.getLanguage().getDefaultVersion();
    }

    public Rule getRule() {
        return this.rule;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(LanguageVersion languageVersion) {
        if (!languageVersion.getLanguage().equals(this.getRule().getLanguage())) {
            throw new IllegalArgumentException("Invalid version " + languageVersion);
        }
        this.languageVersion = languageVersion;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void recordExpectedViolations(int expectedProblems, List<Integer> expectedLineNumbers, List<String> expectedMessages) {
        this.checkListSize(expectedProblems, expectedLineNumbers);
        this.checkListSize(expectedProblems, expectedMessages);
        this.expectedProblems = expectedProblems;
        this.expectedLineNumbers = expectedLineNumbers;
        this.expectedMessages = expectedMessages;
    }

    public void recordExpectedViolations(int expectedProblems, List<Integer> expectedLineNumbers, List<Integer> expectedEndLineNumbers, List<String> expectedMessages) {
        this.checkListSize(expectedProblems, expectedEndLineNumbers);
        this.expectedEndLineNumbers = expectedEndLineNumbers;
        this.recordExpectedViolations(expectedProblems, expectedLineNumbers, expectedMessages);
    }

    private void checkListSize(int expectedProblems, List<?> expectedMessages) {
        if (!expectedMessages.isEmpty() && expectedProblems != expectedMessages.size()) {
            throw new IllegalArgumentException("Expected list of size " + expectedProblems + ", got " + expectedMessages);
        }
    }

    public int getExpectedProblems() {
        return this.expectedProblems;
    }

    public int getIndex() {
        return this.index;
    }

    public List<Integer> getExpectedLineNumbers() {
        return this.expectedLineNumbers;
    }

    public List<Integer> getExpectedEndLineNumbers() {
        return this.expectedEndLineNumbers;
    }

    public List<String> getExpectedMessages() {
        return this.expectedMessages;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }
}

