/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test.schema;

import java.net.URL;
import java.util.Objects;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sourceforge.pmd.test.schema.BaseTestParserImpl;
import org.xml.sax.SAXException;

enum TestSchemaVersion {
    V1("rule-tests_1_1_0.xsd", new BaseTestParserImpl.ParserV1());

    private final Schema schema;
    private String schemaLoc;
    private BaseTestParserImpl parser;

    private TestSchemaVersion(String schemaLoc, BaseTestParserImpl parser) {
        this.schemaLoc = schemaLoc;
        this.parser = parser;
        this.schema = this.parseSchema();
    }

    BaseTestParserImpl getParserImpl() {
        return this.parser;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private Schema parseSchema() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return schemaFactory.newSchema(this.locateSchema());
        }
        catch (SAXException e) {
            throw new RuntimeException("Cannot parse schema " + (Object)((Object)this), e);
        }
    }

    private URL locateSchema() {
        URL resource = TestSchemaVersion.class.getResource(this.schemaLoc);
        return Objects.requireNonNull(resource, "Cannot find schema location " + this.schemaLoc);
    }
}

