/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.testframework.RuleTestRunner;
import net.sourceforge.pmd.testframework.SimpleAggregatorTst;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.JUnit4;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class PMDTestRunner
extends Runner
implements Filterable,
Sortable {
    private final Class<? extends SimpleAggregatorTst> klass;
    private final RuleTestRunner ruleTests;
    private final ParentRunner<?> unitTests;

    public PMDTestRunner(Class<? extends SimpleAggregatorTst> klass) throws InitializationError {
        this.klass = klass;
        this.ruleTests = new RuleTestRunner(klass);
        this.unitTests = this.ruleTests.hasUnitTests() ? new JUnit4(klass) : new EmptyRunner(klass);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        boolean noRuleTests = false;
        try {
            this.ruleTests.filter(filter);
        }
        catch (NoTestsRemainException e) {
            noRuleTests = true;
        }
        boolean noUnitTests = false;
        try {
            this.unitTests.filter(filter);
        }
        catch (NoTestsRemainException e) {
            noUnitTests = false;
        }
        if (noRuleTests && noUnitTests) {
            throw new NoTestsRemainException();
        }
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.klass);
        description.addChild(this.createChildrenDescriptions((Runner)this.ruleTests, "Rule Tests"));
        if (this.ruleTests.hasUnitTests()) {
            description.addChild(this.createChildrenDescriptions((Runner)this.unitTests, "Unit Tests"));
        }
        return description;
    }

    private Description createChildrenDescriptions(Runner runner, String suiteName) {
        Description suite = Description.createSuiteDescription((String)suiteName, (Annotation[])new Annotation[0]);
        for (Description child : runner.getDescription().getChildren()) {
            suite.addChild(child);
        }
        return suite;
    }

    public void run(RunNotifier notifier) {
        this.ruleTests.run(notifier);
        this.unitTests.run(notifier);
    }

    public void sort(Sorter sorter) {
        this.ruleTests.sort(sorter);
        this.unitTests.sort(sorter);
    }

    private static class EmptyRunner
    extends ParentRunner<Object> {
        protected EmptyRunner(Class<?> testClass) throws InitializationError {
            super(testClass);
        }

        public Description getDescription() {
            return Description.EMPTY;
        }

        protected List<Object> getChildren() {
            return Collections.emptyList();
        }

        protected Description describeChild(Object child) {
            return Description.EMPTY;
        }

        protected void runChild(Object child, RunNotifier notifier) {
        }
    }
}

