/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.test.schema.RuleTestCollection;
import net.sourceforge.pmd.test.schema.RuleTestDescriptor;
import net.sourceforge.pmd.testframework.RuleTst;
import net.sourceforge.pmd.testframework.TestDescriptor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class RuleTestRunner
extends ParentRunner<TestDescriptor> {
    private ConcurrentHashMap<TestDescriptor, Description> testDescriptions = new ConcurrentHashMap();
    private final RuleTst instance = this.createTestClass();

    public RuleTestRunner(Class<? extends RuleTst> testClass) throws InitializationError {
        super(testClass);
        this.instance.setUp();
    }

    protected Description describeChild(TestDescriptor testCase) {
        Description description = this.testDescriptions.get(testCase);
        if (description == null) {
            description = Description.createTestDescription((String)this.getTestClass().getJavaClass().getName(), (String)testCase.getTestMethodName(), (Annotation[])new Annotation[0]);
            this.testDescriptions.putIfAbsent(testCase, description);
        }
        return description;
    }

    public boolean hasUnitTests() {
        return !this.getTestClass().getAnnotatedMethods(Test.class).isEmpty();
    }

    protected List<TestDescriptor> getChildren() {
        ArrayList<Rule> rules = new ArrayList<Rule>(this.instance.getRules());
        rules.sort(Comparator.comparing(Rule::getName));
        ArrayList<TestDescriptor> tests = new ArrayList<TestDescriptor>();
        for (Rule r : rules) {
            RuleTestCollection ruleTests = this.instance.parseTestCollection(r);
            RuleTestDescriptor focused = ruleTests.getFocusedTestOrNull();
            for (RuleTestDescriptor t : ruleTests.getTests()) {
                TestDescriptor td = new TestDescriptor(t);
                if (focused != null && !focused.equals(t)) {
                    td.setRegressionTest(false);
                }
                tests.add(td);
            }
        }
        return tests;
    }

    private RuleTst createTestClass() throws InitializationError {
        try {
            return (RuleTst)this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void runChild(TestDescriptor testCase, RunNotifier notifier) {
        Description description = this.describeChild(testCase);
        if (this.isIgnored(testCase)) {
            notifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.ruleTestBlock(testCase), description, notifier);
        }
    }

    private Statement ruleTestBlock(final TestDescriptor testCase) {
        Statement statement = new Statement(){

            public void evaluate() throws Throwable {
                RuleTestRunner.this.instance.runTest(testCase);
            }
        };
        statement = this.withBefores(statement);
        statement = this.withAfters(statement);
        statement = this.withRules(testCase, statement);
        return statement;
    }

    private Statement withBefores(Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, (Object)this.instance);
    }

    private Statement withAfters(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, (Object)this.instance);
    }

    private Statement withRules(TestDescriptor testCase, Statement statement) {
        List testRules = this.getTestClass().getAnnotatedFieldValues((Object)this.instance, org.junit.Rule.class, TestRule.class);
        return testRules.isEmpty() ? statement : new RunRules(statement, (Iterable)testRules, this.describeChild(testCase));
    }

    protected boolean isIgnored(TestDescriptor child) {
        return TestDescriptor.inRegressionTestMode() && !child.isRegressionTest();
    }
}

