/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.test.schema.RuleTestCollection;
import net.sourceforge.pmd.test.schema.RuleTestDescriptor;
import net.sourceforge.pmd.test.schema.TestSchemaParser;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.xml.sax.InputSource;

public abstract class RuleTst {
    private static final ClassLoader TEST_AUXCLASSPATH_CLASSLOADER;

    protected void setUp() {
    }

    protected List<Rule> getRules() {
        return Collections.emptyList();
    }

    protected Collection<? extends Rule> getExtraRules() {
        return Collections.emptyList();
    }

    public static Rule findRule(String ruleSet, String ruleName) {
        try {
            RuleSet parsedRset = new RuleSetLoader().warnDeprecated(false).loadFromResource(ruleSet);
            Rule rule = parsedRset.getRuleByName(ruleName);
            if (rule == null) {
                Assertions.fail((String)("Rule " + ruleName + " not found in ruleset " + ruleSet));
            } else {
                rule.setRuleSetName(ruleSet);
            }
            return rule;
        }
        catch (RuleSetLoadException e) {
            e.printStackTrace();
            Assertions.fail((String)("Couldn't find ruleset " + ruleSet));
            return null;
        }
    }

    void runTest(RuleTestDescriptor test) {
        Rule rule = test.getRule();
        rule = this.reinitializeRule(rule);
        Map oldProperties = rule.getPropertiesByPropertyDescriptor();
        Report report = null;
        try {
            int res;
            try {
                String dysfunctionReason;
                if (test.getProperties() != null) {
                    for (Map.Entry<Object, Object> entry : test.getProperties().entrySet()) {
                        String propertyName = (String)entry.getKey();
                        PropertyDescriptor propertyDescriptor = rule.getPropertyDescriptor(propertyName);
                        if (propertyDescriptor == null) {
                            throw new IllegalArgumentException("No such property '" + propertyName + "' on Rule " + rule.getName());
                        }
                        Object value = propertyDescriptor.serializer().fromString((String)entry.getValue());
                        rule.setProperty(propertyDescriptor, value);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(dysfunctionReason = rule.dysfunctionReason()))) {
                    throw new RuntimeException("Rule is not configured correctly: " + dysfunctionReason);
                }
                report = this.processUsingStringReader(test, rule);
                res = report.getViolations().size();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException('\"' + test.getDescription() + "\" failed", e);
            }
            Assertions.assertEquals((int)test.getExpectedProblems(), (int)res, (String)('\"' + test.getDescription() + "\" resulted in wrong number of failures,"));
            this.assertMessages(report, test);
            this.assertLineNumbers(report, test);
            this.assertSuppressions(report, test);
        }
        catch (AssertionError e) {
            this.printReport(test, report);
            throw e;
        }
        finally {
            for (Map.Entry entry : oldProperties.entrySet()) {
                rule.setProperty((PropertyDescriptor)entry.getKey(), entry.getValue());
            }
        }
    }

    private Rule reinitializeRule(Rule rule) {
        return rule.deepCopy();
    }

    private void assertSuppressions(Report report, RuleTestDescriptor test) {
        if (!test.hasExpectedSuppressions()) {
            return;
        }
        List expectedSuppressions = test.getExpectedSuppressions();
        Assertions.assertEquals((int)expectedSuppressions.size(), (int)report.getSuppressedViolations().size(), (String)"wrong number of suppressed violations");
        for (int i = 0; i < expectedSuppressions.size(); ++i) {
            RuleTestDescriptor.SuppressionDescriptor expectedSuppression = (RuleTestDescriptor.SuppressionDescriptor)expectedSuppressions.get(i);
            Report.SuppressedViolation actualSuppression = (Report.SuppressedViolation)report.getSuppressedViolations().get(i);
            Assertions.assertEquals((int)expectedSuppression.getLine(), (int)actualSuppression.getRuleViolation().getBeginLine(), (String)"wrong line for suppression");
            if (!StringUtils.isNotBlank((CharSequence)expectedSuppression.getSuppressorId())) continue;
            Assertions.assertEquals((Object)expectedSuppression.getSuppressorId(), (Object)actualSuppression.getSuppressor().getId(), (String)"wrong suppressor id");
        }
    }

    private void assertMessages(Report report, RuleTestDescriptor test) {
        if (report == null || test.getExpectedMessages().isEmpty()) {
            return;
        }
        List expectedMessages = test.getExpectedMessages();
        if (report.getViolations().size() != expectedMessages.size()) {
            throw new RuntimeException("Test setup error: number of expected messages doesn't match number of violations for test case '" + test.getDescription() + "'");
        }
        int index = 0;
        for (RuleViolation violation : report.getViolations()) {
            String actual = violation.getDescription();
            Assertions.assertEquals(expectedMessages.get(index), (Object)actual, (String)('\"' + test.getDescription() + "\" produced wrong message on violation number " + (index + 1) + "."));
            ++index;
        }
    }

    private void assertLineNumbers(Report report, RuleTestDescriptor test) {
        if (report == null || test.getExpectedLineNumbers().isEmpty()) {
            return;
        }
        List expected = test.getExpectedLineNumbers();
        List expectedEndLines = test.getExpectedEndLineNumbers();
        if (report.getViolations().size() != expected.size()) {
            throw new RuntimeException("Test setup error: number of expected line numbers " + expected.size() + " doesn't match number of violations " + report.getViolations().size() + " for test case '" + test.getDescription() + "'");
        }
        int index = 0;
        for (RuleViolation violation : report.getViolations()) {
            Integer actualBeginLine = violation.getBeginLine();
            Integer actualEndLine = violation.getEndLine();
            Assertions.assertEquals((Integer)((Integer)expected.get(index)), (Integer)actualBeginLine, (String)('\"' + test.getDescription() + "\" violation on wrong line number: violation number " + (index + 1) + "."));
            if (!expectedEndLines.isEmpty()) {
                Assertions.assertEquals((Integer)((Integer)expectedEndLines.get(index)), (Integer)actualEndLine, (String)('\"' + test.getDescription() + "\" violation on wrong end line number: violation number " + (index + 1) + "."));
            }
            ++index;
        }
    }

    private void printReport(RuleTestDescriptor test, Report report) {
        String separator = "--------------------------------------------------------------";
        System.out.println("--------------------------------------------------------------");
        System.out.println("Test Failure: " + test.getDescription());
        if (report == null) {
            System.out.println("There is no report!");
            System.out.println("--------------------------------------------------------------");
            return;
        }
        System.out.println(" -> Expected " + test.getExpectedProblems() + " problem(s), " + report.getViolations().size() + " problem(s) found.");
        System.out.println(" -> Expected messages: " + test.getExpectedMessages());
        System.out.println(" -> Expected begin line numbers: " + test.getExpectedLineNumbers());
        if (!test.getExpectedEndLineNumbers().isEmpty()) {
            System.out.println(" -> Expected   end line numbers: " + test.getExpectedEndLineNumbers());
        }
        if (test.hasExpectedSuppressions()) {
            System.out.println(" -> Expected " + test.getExpectedSuppressions().size() + " suppression(s), " + report.getSuppressedViolations().size() + " found.");
        }
        System.out.println();
        StringWriter reportOutput = new StringWriter();
        TextRenderer renderer = new TextRenderer();
        renderer.setWriter((Writer)reportOutput);
        try {
            renderer.start();
            renderer.renderFileReport(report);
            renderer.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(reportOutput);
        System.out.println("--------------------------------------------------------------");
    }

    private Report processUsingStringReader(RuleTestDescriptor test, Rule rule) {
        return this.runTestFromString(test.getCode(), rule, test.getLanguageVersion());
    }

    Report runTestFromString(String code, Rule rule, LanguageVersion languageVersion) {
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setIgnoreIncrementalAnalysis(true);
        configuration.setDefaultLanguageVersion(languageVersion);
        configuration.setThreads(0);
        configuration.setClassLoader(TEST_AUXCLASSPATH_CLASSLOADER);
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);){
            pmd.files().addFile(TextFile.forCharSeq((CharSequence)code, (FileId)FileId.fromPathLikeString((String)"file"), (LanguageVersion)languageVersion));
            Collection<? extends Rule> extraRules = this.getExtraRules();
            if (!extraRules.isEmpty()) {
                pmd.addRuleSet(RuleSet.create((String)"extra rules", (String)"description", (String)"file.xml", Collections.emptyList(), Collections.emptyList(), extraRules));
            }
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)rule));
            pmd.addListener(GlobalAnalysisListener.exceptionThrower());
            Report report = pmd.performAnalysisAndCollectReport();
            return report;
        }
    }

    private String getCleanRuleName(Rule rule) {
        String fullClassName = rule.getClass().getName();
        if (fullClassName.equals(rule.getName())) {
            String packageName = rule.getClass().getPackage().getName();
            return fullClassName.substring(packageName.length() + 1);
        }
        return rule.getName();
    }

    RuleTestCollection parseTestCollection(Rule rule) {
        String testsFileName = this.getCleanRuleName(rule);
        return this.parseTestCollection(rule, testsFileName);
    }

    private RuleTestCollection parseTestCollection(Rule rule, String testsFileName) {
        return this.parseTestXml(rule, testsFileName, "xml/");
    }

    private RuleTestCollection parseTestXml(Rule rule, String testsFileName, String baseDirectory) {
        RuleTestCollection ruleTestCollection;
        block9: {
            String testXmlFileName = baseDirectory + testsFileName + ".xml";
            String absoluteUriToTestXmlFile = new File(".").getAbsoluteFile().toURI() + "/src/test/resources/" + this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + testXmlFileName;
            InputStream inputStream = this.getClass().getResourceAsStream(testXmlFileName);
            try {
                if (inputStream == null) {
                    throw new RuntimeException("Couldn't find " + testXmlFileName);
                }
                InputSource source = new InputSource();
                source.setByteStream(inputStream);
                source.setSystemId(testXmlFileName);
                TestSchemaParser parser = new TestSchemaParser();
                RuleTestCollection ruleTestCollection2 = parser.parse(rule, source);
                ruleTestCollection2.setAbsoluteUriToTestXmlFile(absoluteUriToTestXmlFile);
                ruleTestCollection = ruleTestCollection2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + e, e);
                }
            }
            inputStream.close();
        }
        return ruleTestCollection;
    }

    public void runTests(Rule rule) {
        this.runTests(this.parseTestCollection(rule));
    }

    public void runTests(Rule rule, String testsFileName) {
        this.runTests(this.parseTestCollection(rule, testsFileName));
    }

    private void runTests(RuleTestCollection tests) {
        for (RuleTestDescriptor test : tests.getTests()) {
            this.runTest(test);
        }
    }

    @TestFactory
    Collection<DynamicTest> ruleTests() {
        this.setUp();
        ArrayList<Rule> rules = new ArrayList<Rule>(this.getRules());
        rules.sort(Comparator.comparing(Rule::getName));
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (Rule r : rules) {
            RuleTestCollection ruleTests = this.parseTestCollection(r);
            RuleTestDescriptor focused = ruleTests.getFocusedTestOrNull();
            for (RuleTestDescriptor t : ruleTests.getTests()) {
                if (focused != null && !focused.equals(t)) {
                    t.setDisabled(true);
                }
                tests.add(this.toDynamicTest(ruleTests, t));
            }
        }
        return tests;
    }

    private DynamicTest toDynamicTest(RuleTestCollection collection, RuleTestDescriptor testDescriptor) {
        URI testSourceUri = URI.create(collection.getAbsoluteUriToTestXmlFile() + "?line=" + testDescriptor.getLineNumber());
        if (testDescriptor.isDisabled()) {
            return DynamicTest.dynamicTest((String)("[IGNORED] " + testDescriptor.getDescription()), (URI)testSourceUri, () -> {});
        }
        return DynamicTest.dynamicTest((String)testDescriptor.getDescription(), (URI)testSourceUri, () -> this.runTest(testDescriptor));
    }

    static {
        Path PATH_TO_JRT_FS_JAR;
        CodeSource codeSource = Object.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            PATH_TO_JRT_FS_JAR = Paths.get(System.getProperty("java.home"), "lib", "jrt-fs.jar");
        } else {
            URL location = codeSource.getLocation();
            if (!"file".equalsIgnoreCase(location.getProtocol())) {
                throw new IllegalStateException("Object.class loaded in unexpected way from " + location);
            }
            try {
                PATH_TO_JRT_FS_JAR = Paths.get(location.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            TEST_AUXCLASSPATH_CLASSLOADER = new ClasspathClassLoader(PATH_TO_JRT_FS_JAR.toString(), PMDConfiguration.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

