/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf;

import java.util.List;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.apex.ApexLanguageModule;
import net.sourceforge.pmd.lang.impl.SimpleLanguageModuleBase;
import net.sourceforge.pmd.lang.vf.VfHandler;
import net.sourceforge.pmd.lang.vf.VfLanguageProperties;
import net.sourceforge.pmd.util.CollectionUtil;

public class VfLanguageModule
extends SimpleLanguageModuleBase {
    public static final String NAME = "Salesforce VisualForce";
    public static final String TERSE_NAME = "vf";
    @InternalApi
    public static final List<String> EXTENSIONS = CollectionUtil.listOf((Object)"page", (Object[])new String[]{"component"});

    public VfLanguageModule() {
        super(VfLanguageModule.createMetdata(), p -> new VfHandler((VfLanguageProperties)((Object)p)));
    }

    private static LanguageModuleBase.LanguageMetadata createMetdata() {
        LanguageModuleBase.LanguageMetadata languageMetadata = LanguageModuleBase.LanguageMetadata.withId((String)TERSE_NAME).name(NAME).extensions(EXTENSIONS).dependsOnLanguage("apex");
        ApexLanguageModule temporaryApexModule = new ApexLanguageModule();
        LanguageVersion defaultApexVersion = temporaryApexModule.getDefaultVersion();
        for (LanguageVersion languageVersion : temporaryApexModule.getVersions()) {
            if (defaultApexVersion.equals(languageVersion)) continue;
            languageMetadata.addVersion(languageVersion.getVersion(), new String[0]);
        }
        languageMetadata.addDefaultVersion(defaultApexVersion.getVersion(), new String[0]);
        return languageMetadata;
    }

    public LanguagePropertyBundle newPropertyBundle() {
        return new VfLanguageProperties();
    }

    public static Language getInstance() {
        return LanguageRegistry.PMD.getLanguageByFullName(NAME);
    }
}

