/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf.ast;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vf.ast.ASTDotExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTIdentifier;
import net.sourceforge.pmd.lang.vf.ast.ASTLiteral;
import net.sourceforge.pmd.lang.vf.ast.AbstractVfNode;
import net.sourceforge.pmd.lang.vf.ast.VfTypedNode;
import net.sourceforge.pmd.lang.vf.ast.VfVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ASTExpression
extends AbstractVfNode {
    private static final Logger LOG = LoggerFactory.getLogger(ASTExpression.class);

    ASTExpression(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVfVisitor(VfVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    private void logWarning(String warning, Node node) {
        LOG.warn("{}: {}\n{}", new Object[]{node.getReportLocation().startPosToStringWithFile(), warning, node});
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<VfTypedNode, String> getDataNodes() throws DataNodeStateException {
        IdentityHashMap<VfTypedNode, String> result = new IdentityHashMap<VfTypedNode, String>();
        int numChildren = this.getNumChildren();
        List identifiers = this.findChildrenOfType(ASTIdentifier.class);
        Iterator iterator = identifiers.iterator();
        while (iterator.hasNext()) {
            ASTIdentifier identifier = (ASTIdentifier)iterator.next();
            LinkedList<VfTypedNode> identifierNodes = new LinkedList<VfTypedNode>();
            identifierNodes.add(identifier);
            int index = identifier.getIndexInParent();
            ++index;
            while (index < numChildren) {
                Node node = this.getChild(index);
                if (node instanceof ASTDotExpression) {
                    if (node.getNumChildren() != 1) {
                        this.logWarning("More than one child found for ASTDotExpression", node);
                        throw new DataNodeStateException();
                    }
                    Node expressionChild = node.getChild(0);
                    if (!(expressionChild instanceof ASTIdentifier) && !(expressionChild instanceof ASTLiteral)) {
                        this.logWarning("Node expected to be Identifier or Literal", node);
                        throw new DataNodeStateException();
                    }
                    identifierNodes.add((VfTypedNode)expressionChild);
                    ++index;
                    continue;
                }
                if (!(node instanceof ASTExpression)) break;
                throw new DataNodeStateException();
            }
            String idString = String.join((CharSequence)".", identifierNodes.stream().map(i -> i.getImage()).collect(Collectors.toList()));
            result.put((VfTypedNode)identifierNodes.getLast(), idString);
        }
        return result;
    }

    public static final class DataNodeStateException
    extends Exception {
    }
}

