/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexVisitorBase;
import org.apache.commons.lang3.tuple.Pair;

final class ApexClassPropertyTypesVisitor
extends ApexVisitorBase<Void, Void> {
    private static final String BEAN_GETTER_PREFIX = "get";
    private static final String PROPERTY_PREFIX_ACCESSOR = "__sfdc_";
    private static final String RETURN_TYPE_VOID = "void";
    private final List<Pair<String, String>> variables = new ArrayList<Pair<String, String>>();

    ApexClassPropertyTypesVisitor() {
    }

    public List<Pair<String, String>> getVariables() {
        return this.variables;
    }

    public Void visit(ASTMethod node, Void data) {
        if (node.getArity() == 0 && this.isVisibleToVisualForce(node) && !RETURN_TYPE_VOID.equalsIgnoreCase(node.getReturnType()) && (node.hasRealLoc() || node.getFirstParentOfType(ASTProperty.class) != null)) {
            StringBuilder sb = new StringBuilder();
            List parents = node.getParentsOfType(ASTUserClass.class);
            Collections.reverse(parents);
            for (ASTUserClass parent : parents) {
                sb.append(parent.getImage()).append(".");
            }
            String name = node.getImage();
            for (String prefix : new String[]{BEAN_GETTER_PREFIX, PROPERTY_PREFIX_ACCESSOR}) {
                if (!name.startsWith(prefix)) continue;
                name = name.substring(prefix.length());
            }
            sb.append(name);
            this.variables.add((Pair<String, String>)Pair.of((Object)sb.toString(), (Object)node.getReturnType()));
        }
        return (Void)this.visitApexNode((ApexNode)node, data);
    }

    private boolean isVisibleToVisualForce(ASTMethod node) {
        ASTModifierNode modifier = (ASTModifierNode)node.getFirstChildOfType(ASTModifierNode.class);
        return modifier.isGlobal() | modifier.isPublic();
    }
}

