/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf.ast;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.vf.DataType;

abstract class SalesforceFieldTypes {
    private final Map<String, DataType> variableNameToVariableType = new HashMap<String, DataType>();
    private final Set<String> variableNameProcessed = new HashSet<String>();

    SalesforceFieldTypes() {
    }

    public DataType getDataType(String expression, FileId vfFileName, List<String> metadataDirectories) {
        String lowerExpression = expression.toLowerCase(Locale.ROOT);
        if (this.variableNameToVariableType.containsKey(lowerExpression)) {
            return this.variableNameToVariableType.get(lowerExpression);
        }
        if (this.variableNameProcessed.contains(lowerExpression)) {
            return null;
        }
        Path vfFilePath = Paths.get(vfFileName.getAbsolutePath(), new String[0]);
        ArrayList<Path> resolvedPaths = new ArrayList<Path>();
        for (String metadataDirectory : metadataDirectories) {
            if (Paths.get(metadataDirectory, new String[0]).isAbsolute()) {
                resolvedPaths.add(Paths.get(metadataDirectory, new String[0]));
                continue;
            }
            resolvedPaths.add(vfFilePath.getParent().resolve(metadataDirectory));
        }
        this.findDataType(expression, resolvedPaths);
        this.variableNameProcessed.add(lowerExpression);
        return this.variableNameToVariableType.get(lowerExpression);
    }

    protected DataType putDataType(String expression, DataType dataType) {
        return this.variableNameToVariableType.put(expression.toLowerCase(Locale.ROOT), dataType);
    }

    protected boolean containsExpression(String expression) {
        return this.variableNameToVariableType.containsKey(expression.toLowerCase(Locale.ROOT));
    }

    protected abstract void findDataType(String var1, List<Path> var2);
}

