/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce.ast;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.apex.ApexLanguageModule;
import net.sourceforge.pmd.lang.apex.ApexLanguageProcessor;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.visualforce.DataType;
import net.sourceforge.pmd.lang.visualforce.ast.ApexClassPropertyTypesVisitor;
import net.sourceforge.pmd.lang.visualforce.ast.SalesforceFieldTypes;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApexClassPropertyTypes
extends SalesforceFieldTypes {
    private static final Logger LOG = LoggerFactory.getLogger(ApexClassPropertyTypes.class);
    private static final String APEX_CLASS_FILE_SUFFIX = ".cls";
    private final ApexLanguageProcessor apexProcessor;
    private final LanguageProcessorRegistry lpReg;

    ApexClassPropertyTypes(LanguageProcessorRegistry lpReg) {
        this.apexProcessor = (ApexLanguageProcessor)lpReg.getProcessor((Language)ApexLanguageModule.getInstance());
        this.lpReg = lpReg;
    }

    @Override
    public void findDataType(String expression, List<Path> apexDirectories) {
        String[] parts = expression.split("\\.");
        if (parts.length >= 2) {
            String className = parts[0];
            for (Path apexDirectory : apexDirectories) {
                Path apexFilePath = apexDirectory.resolve(className + APEX_CLASS_FILE_SUFFIX);
                if (!Files.exists(apexFilePath, new LinkOption[0]) || !Files.isRegularFile(apexFilePath, new LinkOption[0])) continue;
                Node node = this.parseApex(expression, apexFilePath);
                ApexClassPropertyTypesVisitor visitor = new ApexClassPropertyTypesVisitor();
                node.acceptVisitor((AstVisitor)visitor, null);
                for (Pair<String, String> variable : visitor.getVariables()) {
                    this.putDataType((String)variable.getKey(), DataType.fromTypeName((String)variable.getValue()));
                }
                if (!this.containsExpression(expression)) continue;
                break;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Node parseApex(Path apexFilePath) {
        LanguageVersion languageVersion = this.apexProcessor.getLanguageVersion();
        try (TextFile file = TextFile.forPath((Path)apexFilePath, (Charset)StandardCharsets.UTF_8, (LanguageVersion)languageVersion);){
            RootNode rootNode;
            block14: {
                TextDocument textDocument = TextDocument.create((TextFile)file);
                try {
                    Parser parser = this.apexProcessor.services().getParser();
                    Parser.ParserTask task = new Parser.ParserTask(textDocument, SemanticErrorReporter.noop(), this.lpReg);
                    rootNode = parser.parse(task);
                    if (textDocument == null) break block14;
                }
                catch (Throwable throwable) {
                    if (textDocument != null) {
                        try {
                            textDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                textDocument.close();
            }
            return rootNode;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e).addContextValue("apexFilePath", (Object)apexFilePath);
        }
    }

    private Node parseApex(String contextExpr, Path apexFilePath) {
        try {
            return this.parseApex(apexFilePath);
        }
        catch (ContextedRuntimeException e) {
            throw e.addContextValue("expression", (Object)contextExpr);
        }
    }

    @Override
    protected DataType putDataType(String name, DataType dataType) {
        DataType previousType = super.putDataType(name, dataType);
        if (previousType != null && !previousType.equals((Object)dataType)) {
            super.putDataType(name, DataType.Unknown);
            LOG.warn("Conflicting types for {}. CurrentType={}, PreviousType={}", new Object[]{name, dataType, previousType});
        }
        return previousType;
    }
}

