/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce.rule.security;

import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.visualforce.ast.ASTContent;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElement;
import net.sourceforge.pmd.lang.visualforce.ast.ASTText;
import net.sourceforge.pmd.lang.visualforce.ast.VfNode;
import net.sourceforge.pmd.lang.visualforce.rule.AbstractVfRule;
import net.sourceforge.pmd.lang.visualforce.rule.security.internal.ElEscapeDetector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VfHtmlStyleTagXssRule
extends AbstractVfRule {
    private static final String STYLE_TAG = "style";
    private static final String APEX_PREFIX = "apex";
    private static final Set<ElEscapeDetector.Escaping> URLENCODE_JSINHTMLENCODE = EnumSet.of(ElEscapeDetector.Escaping.URLENCODE, ElEscapeDetector.Escaping.JSINHTMLENCODE);
    private static final Set<ElEscapeDetector.Escaping> ANY_ENCODE = EnumSet.of(ElEscapeDetector.Escaping.ANY);
    private static final Pattern URL_METHOD_PATTERN = Pattern.compile("url\\s*\\([^)]*$", 2);

    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTElExpression.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTElExpression node, Object data) {
        VfNode nodeParent = (VfNode)node.getParent();
        if (!(nodeParent instanceof ASTContent)) {
            return data;
        }
        ASTContent contentNode = (ASTContent)nodeParent;
        VfNode nodeGrandParent = (VfNode)contentNode.getParent();
        if (!(nodeGrandParent instanceof ASTElement)) {
            return data;
        }
        ASTElement elementNode = (ASTElement)nodeGrandParent;
        if (this.isApexPrefixed(elementNode)) {
            return data;
        }
        this.verifyEncoding(node, contentNode, elementNode, data);
        return data;
    }

    private void verifyEncoding(ASTElExpression node, ASTContent contentNode, ASTElement elementNode, Object data) {
        String previousText = this.getPreviousText(contentNode, node);
        boolean isWithinSafeResource = ElEscapeDetector.startsWithSafeResource(node);
        if (this.isStyleTag(elementNode) && !isWithinSafeResource) {
            if (VfHtmlStyleTagXssRule.isWithinUrlMethod(previousText)) {
                this.verifyEncodingWithinUrl(node, data);
            } else {
                this.verifyEncodingWithoutUrl(node, data);
            }
        }
    }

    private boolean isStyleTag(ASTElement elementNode) {
        return STYLE_TAG.equalsIgnoreCase(elementNode.getLocalName());
    }

    private void verifyEncodingWithinUrl(ASTElExpression elExpressionNode, Object data) {
        if (ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(elExpressionNode, URLENCODE_JSINHTMLENCODE)) {
            this.asCtx(data).addViolationWithMessage((Node)elExpressionNode, "Dynamic EL content within URL in style tag should be URLENCODED or JSINHTMLENCODED as appropriate");
        }
    }

    private void verifyEncodingWithoutUrl(ASTElExpression elExpressionNode, Object data) {
        if (ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(elExpressionNode, ANY_ENCODE)) {
            this.asCtx(data).addViolationWithMessage((Node)elExpressionNode, "Dynamic EL content in style tag should be appropriately encoded");
        }
    }

    private boolean isApexPrefixed(ASTElement node) {
        return node.isHasNamespacePrefix() && APEX_PREFIX.equalsIgnoreCase(node.getNamespacePrefix());
    }

    private String getPreviousText(ASTContent content, ASTElExpression elExpressionNode) {
        int indexInParent = elExpressionNode.getIndexInParent();
        VfNode previous = indexInParent > 0 ? (VfNode)content.getChild(indexInParent - 1) : null;
        return previous instanceof ASTText ? previous.getImage() : "";
    }

    static boolean isWithinUrlMethod(String previousText) {
        return URL_METHOD_PATTERN.matcher(previousText).find();
    }
}

