/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataType {
    AutoNumber(false),
    Checkbox(false, "Boolean"),
    Currency(false, "Currency"),
    Date(false, "Date"),
    DateTime(false, "Datetime"),
    Email(false),
    EncryptedText(true),
    ExternalLookup(true),
    File(false),
    Hierarchy(false),
    Html(false),
    IndirectLookup(false),
    Location(false),
    LongTextArea(true),
    Lookup(false, "Id"),
    MasterDetail(false),
    MetadataRelationship(false),
    MultiselectPicklist(true),
    Note(true),
    Number(false, "Decimal", "Double", "Integer", "Long"),
    Percent(false),
    Phone(false),
    Picklist(true),
    Summary(false),
    Text(true, "String"),
    TextArea(true),
    Time(false, "Time"),
    Url(false),
    Unknown(true);

    private static final Logger LOG;
    public final boolean requiresEscaping;
    private final Set<String> basicTypeNames;
    private static final Map<String, DataType> CASE_NORMALIZED_MAP;
    private static final Map<String, DataType> BASIC_TYPE_MAP;

    public static DataType fromString(String value) {
        DataType dataType = CASE_NORMALIZED_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOG.debug("Unable to determine DataType of {}", (Object)value);
        }
        return dataType;
    }

    public static DataType fromTypeName(String value) {
        DataType dataType = BASIC_TYPE_MAP.get((value = value != null ? value : "").toLowerCase(Locale.ROOT));
        if (dataType == null) {
            dataType = Unknown;
            LOG.debug("Unable to determine DataType of {}", (Object)value);
        }
        return dataType;
    }

    private DataType(boolean requiresEscaping) {
        this(requiresEscaping, null);
    }

    private DataType(boolean requiresEscaping, String ... basicTypeNames) {
        this.requiresEscaping = requiresEscaping;
        this.basicTypeNames = new HashSet<String>();
        if (basicTypeNames != null) {
            this.basicTypeNames.addAll(Arrays.asList(basicTypeNames));
        }
    }

    static {
        LOG = LoggerFactory.getLogger(DataType.class);
        CASE_NORMALIZED_MAP = new HashMap<String, DataType>();
        BASIC_TYPE_MAP = new HashMap<String, DataType>();
        for (DataType dataType : DataType.values()) {
            CASE_NORMALIZED_MAP.put(dataType.name().toLowerCase(Locale.ROOT), dataType);
            for (String typeName : dataType.basicTypeNames) {
                BASIC_TYPE_MAP.put(typeName.toLowerCase(Locale.ROOT), dataType);
            }
        }
    }
}

