/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce.ast;

import com.google.common.reflect.ClassPath;
import com.nawforce.runforce.SObjects.Account;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sourceforge.pmd.lang.visualforce.DataType;
import net.sourceforge.pmd.lang.visualforce.ast.SalesforceFieldTypes;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ObjectFieldTypes
extends SalesforceFieldTypes {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFieldTypes.class);
    public static final String CUSTOM_OBJECT_SUFFIX = "__c";
    private static final String FIELDS_DIRECTORY = "fields";
    private static final String MDAPI_OBJECT_FILE_SUFFIX = ".object";
    private static final String SFDX_FIELD_FILE_SUFFIX = ".field-meta.xml";
    private static final Map<String, DataType> SYSTEM_FIELDS = new HashMap<String, DataType>();
    private static final Map<String, ClassPath.ClassInfo> SOBJECTS;
    private final Set<String> objectFileProcessed = new HashSet<String>();
    private final DocumentBuilder documentBuilder;
    private final XPathExpression customObjectFieldsExpression;
    private final XPathExpression customFieldFullNameExpression;
    private final XPathExpression customFieldTypeExpression;
    private final XPathExpression sfdxCustomFieldFullNameExpression;
    private final XPathExpression sfdxCustomFieldTypeExpression;

    ObjectFieldTypes() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setCoalescing(false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            this.customObjectFieldsExpression = xPath.compile("/CustomObject/fields");
            this.customFieldFullNameExpression = xPath.compile("fullName/text()");
            this.customFieldTypeExpression = xPath.compile("type/text()");
            this.sfdxCustomFieldFullNameExpression = xPath.compile("/CustomField/fullName/text()");
            this.sfdxCustomFieldTypeExpression = xPath.compile("/CustomField/type/text()");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void findDataType(String expression, List<Path> objectsDirectories) {
        String[] parts = expression.split("\\.");
        if (parts.length == 1) {
            throw new RuntimeException("Malformed identifier: " + expression);
        }
        if (parts.length == 2) {
            String objectName = parts[0];
            String fieldName = parts[1];
            this.addSystemFields(objectName);
            for (Path objectsDirectory : objectsDirectories) {
                Path sfdxCustomFieldPath = this.getSfdxCustomFieldPath(objectsDirectory, objectName, fieldName);
                if (sfdxCustomFieldPath != null) {
                    this.parseSfdxCustomField(objectName, sfdxCustomFieldPath);
                } else {
                    String fileName = objectName + MDAPI_OBJECT_FILE_SUFFIX;
                    Path mdapiPath = objectsDirectory.resolve(fileName);
                    if (Files.exists(mdapiPath, new LinkOption[0]) && Files.isRegularFile(mdapiPath, new LinkOption[0])) {
                        this.parseMdapiCustomObject(mdapiPath);
                    }
                }
                if (!this.containsExpression(expression)) continue;
                break;
            }
        } else {
            LOG.debug("Expression does not have two parts: {}", (Object)expression);
        }
    }

    private Path getSfdxCustomFieldPath(Path objectsDirectory, String objectName, String fieldName) {
        Path sfdxFieldPath;
        Path fieldsDirectoryPath = Paths.get(objectsDirectory.toString(), objectName, FIELDS_DIRECTORY);
        if (Files.exists(fieldsDirectoryPath, new LinkOption[0]) && Files.isDirectory(fieldsDirectoryPath, new LinkOption[0]) && Files.exists(sfdxFieldPath = Paths.get(fieldsDirectoryPath.toString(), fieldName + SFDX_FIELD_FILE_SUFFIX), new LinkOption[0]) && Files.isRegularFile(sfdxFieldPath, new LinkOption[0])) {
            return sfdxFieldPath;
        }
        return null;
    }

    private void parseSfdxCustomField(String customObjectName, Path sfdxCustomFieldPath) {
        try {
            Document document = this.documentBuilder.parse(sfdxCustomFieldPath.toFile());
            Node fullNameNode = (Node)this.sfdxCustomFieldFullNameExpression.evaluate(document, XPathConstants.NODE);
            Node typeNode = (Node)this.sfdxCustomFieldTypeExpression.evaluate(document, XPathConstants.NODE);
            DataType dataType = null;
            if (typeNode != null) {
                String type = typeNode.getNodeValue();
                dataType = DataType.fromString(type);
            } else {
                ClassPath.ClassInfo classInfo = SOBJECTS.get(customObjectName.toLowerCase(Locale.ROOT));
                if (classInfo != null) {
                    Field[] fields;
                    for (Field f : fields = classInfo.load().getFields()) {
                        if (!f.getName().equalsIgnoreCase(fullNameNode.getNodeValue())) continue;
                        dataType = DataType.fromTypeName(f.getType().getSimpleName());
                        break;
                    }
                    if (dataType == null) {
                        LOG.warn("Couldn't determine data type of customObjectName={} from {}", (Object)customObjectName, (Object)sfdxCustomFieldPath);
                        dataType = DataType.Unknown;
                    }
                } else {
                    LOG.warn("Couldn't determine data type of customObjectName={} - no sobject definition found", (Object)customObjectName);
                    dataType = DataType.Unknown;
                }
            }
            String key = customObjectName + "." + fullNameNode.getNodeValue();
            this.putDataType(key, dataType);
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            throw new ContextedRuntimeException((Throwable)e).addContextValue("customObjectName", (Object)customObjectName).addContextValue("sfdxCustomFieldPath", (Object)sfdxCustomFieldPath);
        }
    }

    private void parseMdapiCustomObject(Path mdapiObjectFile) {
        String fileName = mdapiObjectFile.getFileName().toString();
        String customObjectName = fileName.substring(0, fileName.lastIndexOf(MDAPI_OBJECT_FILE_SUFFIX));
        if (!this.objectFileProcessed.contains(customObjectName)) {
            try {
                Document document = this.documentBuilder.parse(mdapiObjectFile.toFile());
                NodeList fieldsNodes = (NodeList)this.customObjectFieldsExpression.evaluate(document, XPathConstants.NODESET);
                for (int i = 0; i < fieldsNodes.getLength(); ++i) {
                    Node fieldsNode = fieldsNodes.item(i);
                    Node fullNameNode = (Node)this.customFieldFullNameExpression.evaluate(fieldsNode, XPathConstants.NODE);
                    if (fullNameNode == null) {
                        throw new RuntimeException("fullName evaluate failed for " + customObjectName + " " + fieldsNode.getTextContent());
                    }
                    String name = fullNameNode.getNodeValue();
                    if (!this.endsWithIgnoreCase(name, CUSTOM_OBJECT_SUFFIX)) continue;
                    Node typeNode = (Node)this.customFieldTypeExpression.evaluate(fieldsNode, XPathConstants.NODE);
                    if (typeNode == null) {
                        throw new RuntimeException("type evaluate failed for object=" + customObjectName + ", field=" + name + " " + fieldsNode.getTextContent());
                    }
                    String type = typeNode.getNodeValue();
                    DataType dataType = DataType.fromString(type);
                    String key = customObjectName + "." + fullNameNode.getNodeValue();
                    this.putDataType(key, dataType);
                }
            }
            catch (IOException | XPathExpressionException | SAXException e) {
                throw new ContextedRuntimeException((Throwable)e).addContextValue("customObjectName", (Object)customObjectName).addContextValue("mdapiObjectFile", (Object)mdapiObjectFile);
            }
            this.objectFileProcessed.add(customObjectName);
        }
    }

    private void addSystemFields(String customObjectName) {
        for (Map.Entry<String, DataType> entry : SYSTEM_FIELDS.entrySet()) {
            this.putDataType(customObjectName + "." + entry.getKey(), entry.getValue());
        }
    }

    private boolean endsWithIgnoreCase(String str, String suffix) {
        return str != null && str.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT));
    }

    @Override
    protected DataType putDataType(String name, DataType dataType) {
        DataType previousType = super.putDataType(name, dataType);
        if (previousType != null && !previousType.equals((Object)dataType)) {
            throw new RuntimeException("Conflicting types for " + name + ". CurrentType=" + (Object)((Object)dataType) + ", PreviousType=" + (Object)((Object)previousType));
        }
        return previousType;
    }

    static {
        SYSTEM_FIELDS.put("id", DataType.Lookup);
        SYSTEM_FIELDS.put("isdeleted", DataType.Checkbox);
        SYSTEM_FIELDS.put("createdbyid", DataType.Lookup);
        SYSTEM_FIELDS.put("createddate", DataType.DateTime);
        SYSTEM_FIELDS.put("lastmodifiedbyid", DataType.Lookup);
        SYSTEM_FIELDS.put("lastmodifieddate", DataType.DateTime);
        SYSTEM_FIELDS.put("systemmodstamp", DataType.DateTime);
        SYSTEM_FIELDS.put("name", DataType.Text);
        try {
            SOBJECTS = Collections.unmodifiableMap(ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClasses(Account.class.getPackage().getName()).stream().collect(Collectors.toMap(c -> c.getSimpleName().toLowerCase(Locale.ROOT), Function.identity())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

