/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.visualforce.rule.security.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.lang.visualforce.DataType;
import net.sourceforge.pmd.lang.visualforce.ast.ASTArguments;
import net.sourceforge.pmd.lang.visualforce.ast.ASTDotExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTElExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTExpression;
import net.sourceforge.pmd.lang.visualforce.ast.ASTIdentifier;
import net.sourceforge.pmd.lang.visualforce.ast.ASTNegationExpression;
import net.sourceforge.pmd.lang.visualforce.ast.VfNode;
import net.sourceforge.pmd.lang.visualforce.ast.VfTypedNode;

public final class ElEscapeDetector {
    private static final Set<String> SAFE_PROPERTIES = new HashSet<String>(Arrays.asList("id", "size", "caseNumber"));
    private static final Set<String> SAFE_BUILTIN_FUNCTIONS = new HashSet<String>(Arrays.asList("addmonths", "date", "datevalue", "datetimevalue", "day", "hour", "millisecond", "minute", "month", "now", "second", "timenow", "timevalue", "today", "weekday", "year", "and", "isblank", "isclone", "isnew", "isnull", "isnumber", "not", "or", "abs", "ceiling", "exp", "floor", "ln", "log", "max", "mceiling", "mfloor", "min", "mod", "round", "sqrt", "begins", "br", "casesafeid", "contains", "find", "getsessionid", "ispickval", "len", "currencyrate", "getrecordids", "ischanged", "junctionidlist", "linkto", "regex", "urlfor"));
    private static final Set<String> FUNCTIONS_WITH_XSSABLE_ARG0 = new HashSet<String>(Arrays.asList("left", "lower", "lpad", "mid", "right", "rpad", "upper"));
    private static final Set<String> FUNCTIONS_WITH_XSSABLE_ARG2 = new HashSet<String>(Arrays.asList("lpad", "rpad"));
    private static final Set<String> SAFE_GLOBAL_VARS = new HashSet<String>(Arrays.asList("$action", "$page", "$site", "$resource", "$label", "$objecttype", "$component", "$remoteaction", "$messagechannel"));

    private ElEscapeDetector() {
    }

    private static VfNode getNextSibling(VfNode node) {
        VfNode parent = (VfNode)node.getParent();
        if (parent != null && node.getIndexInParent() < parent.getNumChildren() - 1) {
            return (VfNode)parent.getChild(node.getIndexInParent() + 1);
        }
        return null;
    }

    public static boolean expressionRecursivelyValid(ASTExpression expression, Set<Escaping> escapes) {
        int childCount = expression.getNumChildren();
        String prevId = "";
        ArrayList<ASTExpression> relevantChildren = new ArrayList<ASTExpression>();
        for (int i = 0; i < childCount; ++i) {
            VfNode child = (VfNode)expression.getChild(i);
            if (child instanceof ASTIdentifier) {
                VfNode nextNode = ElEscapeDetector.getNextSibling(child);
                if (nextNode instanceof ASTArguments || nextNode instanceof ASTDotExpression) {
                    prevId = child.getImage();
                    continue;
                }
                if (ElEscapeDetector.typedNodeIsSafe((ASTIdentifier)child)) continue;
                return false;
            }
            if (child instanceof ASTArguments) {
                if (ElEscapeDetector.functionIsEscape(prevId, escapes) || ElEscapeDetector.functionInherentlySafe(prevId)) continue;
                relevantChildren.addAll(ElEscapeDetector.getXssableArguments(prevId, (ASTArguments)child));
                continue;
            }
            if (child instanceof ASTDotExpression) {
                ASTIdentifier propId;
                if (ElEscapeDetector.isSafeGlobal(prevId) || ElEscapeDetector.getNextSibling(child) instanceof ASTDotExpression || (propId = (ASTIdentifier)child.firstChild(ASTIdentifier.class)) == null || ElEscapeDetector.isSafeProperty(propId.getImage()) || ElEscapeDetector.typedNodeIsSafe(propId)) continue;
                return false;
            }
            if (!(child instanceof ASTExpression)) continue;
            relevantChildren.add((ASTExpression)child);
        }
        for (ASTExpression e : relevantChildren) {
            if (ElEscapeDetector.expressionRecursivelyValid(e, escapes)) continue;
            return false;
        }
        return true;
    }

    private static boolean functionIsEscape(String functionName, Set<Escaping> escapes) {
        Set<Escaping> handledEscapes = escapes.contains((Object)Escaping.ANY) ? EnumSet.allOf(Escaping.class) : escapes;
        for (Escaping e : handledEscapes) {
            if (!functionName.equalsIgnoreCase(e.toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean functionInherentlySafe(String functionName) {
        String lowerCaseName = functionName.toLowerCase(Locale.ROOT);
        return SAFE_BUILTIN_FUNCTIONS.contains(lowerCaseName);
    }

    private static List<ASTExpression> getXssableArguments(String functionName, ASTArguments arguments) {
        ArrayList<ASTExpression> exprs = new ArrayList<ASTExpression>();
        int argCount = arguments.getNumChildren();
        if (argCount != 0) {
            int i;
            String lowerCaseName = functionName.toLowerCase(Locale.ROOT);
            ArrayList<Integer> indicesToCheck = new ArrayList<Integer>();
            if ("case".equals(lowerCaseName)) {
                for (int i2 = 2; i2 < argCount; i2 += 2) {
                    indicesToCheck.add(i2);
                }
                indicesToCheck.add(argCount - 1);
            } else if ("if".equals(lowerCaseName)) {
                indicesToCheck.add(1);
                indicesToCheck.add(2);
            } else {
                boolean checkAllArgs = true;
                if (FUNCTIONS_WITH_XSSABLE_ARG0.contains(lowerCaseName)) {
                    checkAllArgs = false;
                    indicesToCheck.add(0);
                }
                if (argCount > 2 && FUNCTIONS_WITH_XSSABLE_ARG2.contains(lowerCaseName)) {
                    checkAllArgs = false;
                    indicesToCheck.add(2);
                }
                if (checkAllArgs) {
                    for (i = 0; i < argCount; ++i) {
                        indicesToCheck.add(i);
                    }
                }
            }
            Iterator iterator = indicesToCheck.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                VfNode ithArg = (VfNode)arguments.getChild(i);
                if (!(ithArg instanceof ASTExpression)) continue;
                exprs.add((ASTExpression)ithArg);
            }
        }
        return exprs;
    }

    private static boolean isSafeGlobal(String id) {
        String lowerCaseId = id.toLowerCase(Locale.ROOT);
        return SAFE_GLOBAL_VARS.contains(lowerCaseId);
    }

    private static boolean isSafeProperty(String propertyName) {
        String lowerCaseName = propertyName.toLowerCase(Locale.ROOT);
        return SAFE_PROPERTIES.contains(lowerCaseName);
    }

    private static boolean innerContainsSafeFields(VfNode expression) {
        for (VfNode child : expression.children()) {
            if (child instanceof ASTIdentifier && ElEscapeDetector.isSafeProperty(child.getImage())) {
                return true;
            }
            if (child instanceof ASTArguments && ElEscapeDetector.containsSafeFields((ASTArguments)child)) {
                return true;
            }
            if (!(child instanceof ASTDotExpression) || !ElEscapeDetector.innerContainsSafeFields((ASTDotExpression)child)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSafeFields(VfNode expression) {
        ASTExpression ex = (ASTExpression)expression.firstChild(ASTExpression.class);
        return ex != null && ElEscapeDetector.innerContainsSafeFields(ex);
    }

    public static boolean startsWithSafeResource(ASTElExpression el) {
        ASTExpression expression = (ASTExpression)el.firstChild(ASTExpression.class);
        if (expression != null) {
            ASTNegationExpression negation = (ASTNegationExpression)expression.firstChild(ASTNegationExpression.class);
            if (negation != null) {
                return true;
            }
            ASTIdentifier id = (ASTIdentifier)expression.firstChild(ASTIdentifier.class);
            if (id != null) {
                if (expression.children(ASTArguments.class).nonEmpty()) {
                    return ElEscapeDetector.functionInherentlySafe(id.getImage());
                }
                return ElEscapeDetector.isSafeGlobal(id.getImage());
            }
        }
        return false;
    }

    public static boolean doesElContainAnyUnescapedIdentifiers(ASTElExpression elExpression, Escaping escape) {
        return ElEscapeDetector.doesElContainAnyUnescapedIdentifiers(elExpression, EnumSet.of(escape));
    }

    public static boolean doesElContainAnyUnescapedIdentifiers(ASTElExpression elExpression, Set<Escaping> escapes) {
        if (elExpression == null) {
            return false;
        }
        HashSet<ASTIdentifier> nonEscapedIds = new HashSet<ASTIdentifier>();
        for (ASTExpression expr : elExpression.children(ASTExpression.class)) {
            if (ElEscapeDetector.innerContainsSafeFields(expr) || ElEscapeDetector.expressionContainsSafeDataNodes(expr)) continue;
            for (ASTIdentifier id : expr.children(ASTIdentifier.class)) {
                boolean isEscaped = false;
                block2: for (Escaping e : escapes) {
                    if (id.getImage().equalsIgnoreCase(e.toString())) {
                        isEscaped = true;
                        break;
                    }
                    if (!e.equals((Object)Escaping.ANY)) continue;
                    for (Escaping esc : Escaping.values()) {
                        if (!id.getImage().equalsIgnoreCase(esc.toString())) continue;
                        isEscaped = true;
                        continue block2;
                    }
                }
                if (isEscaped) continue;
                nonEscapedIds.add(id);
            }
        }
        return !nonEscapedIds.isEmpty();
    }

    private static boolean expressionContainsSafeDataNodes(ASTExpression expression) {
        try {
            for (VfTypedNode node : expression.getDataNodes().keySet()) {
                if (ElEscapeDetector.typedNodeIsSafe(node)) continue;
                return false;
            }
            return true;
        }
        catch (ASTExpression.DataNodeStateException e) {
            return false;
        }
    }

    private static boolean typedNodeIsSafe(VfTypedNode node) {
        DataType dataType = node.getDataType();
        return dataType != null && !dataType.requiresEscaping;
    }

    public static enum Escaping {
        HTMLENCODE("HTMLENCODE"),
        URLENCODE("URLENCODE"),
        JSINHTMLENCODE("JSINHTMLENCODE"),
        JSENCODE("JSENCODE"),
        ANY("ANY");

        private final String text;

        private Escaping(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

