/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.vm.ast.AbstractVmNode;
import net.sourceforge.pmd.lang.vm.ast.VmVisitor;

public final class ASTDirective
extends AbstractVmNode {
    private static final Set<String> DIRECTIVE_NAMES;
    private static final Set<String> BLOCK_DIRECTIVES;
    private static final Set<String> LINE_DIRECTIVES;
    private String directiveName = "";

    ASTDirective(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVmVisitor(VmVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    void setDirectiveName(String str) {
        this.directiveName = str;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    boolean isDirective() {
        assert (this.directiveName != null);
        return DIRECTIVE_NAMES.contains(this.directiveName);
    }

    boolean isBlock() {
        assert (this.directiveName != null);
        return this.directiveName.startsWith("@") || BLOCK_DIRECTIVES.contains(this.directiveName);
    }

    boolean isLine() {
        assert (this.directiveName != null);
        return LINE_DIRECTIVES.contains(this.directiveName) || !this.isDirective();
    }

    static {
        HashSet<String> blocks = new HashSet<String>();
        blocks.add("define");
        blocks.add("foreach");
        blocks.add("literal");
        blocks.add("macro");
        HashSet<String> lines = new HashSet<String>();
        lines.add("break");
        lines.add("evaluate");
        lines.add("include");
        lines.add("parse");
        lines.add("stop");
        HashSet<String> directives = new HashSet<String>();
        directives.addAll(blocks);
        directives.addAll(lines);
        DIRECTIVE_NAMES = Collections.unmodifiableSet(directives);
        BLOCK_DIRECTIVES = Collections.unmodifiableSet(blocks);
        LINE_DIRECTIVES = Collections.unmodifiableSet(lines);
    }
}

