/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.rule.design;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vm.ast.ASTText;
import net.sourceforge.pmd.lang.vm.rule.AbstractVmRule;

public class NoInlineJavaScriptRule
extends AbstractVmRule {
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("<script\\s[^>]*>", 2);
    private static final Pattern SRC_PATTERN = Pattern.compile("\\ssrc\\s*=", 2);

    @Override
    public Object visit(ASTText node, Object data) {
        Matcher matcher = SCRIPT_PATTERN.matcher(node.literal());
        while (matcher.find()) {
            String currentMatch = matcher.group();
            if (SRC_PATTERN.matcher(currentMatch).find()) continue;
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }
}

