/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.xml.ast.AbstractDomNodeProxy;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.XmlParser;
import net.sourceforge.pmd.util.CompoundIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlNodeWrapper
extends AbstractDomNodeProxy
implements XmlNode {
    private final XmlParser parser;
    private Object userData;

    public XmlNodeWrapper(XmlParser parser, org.w3c.dom.Node domNode) {
        super(domNode);
        this.parser = parser;
    }

    public void jjtClose() {
        throw new UnsupportedOperationException();
    }

    public void jjtSetParent(Node parent) {
        throw new UnsupportedOperationException();
    }

    public XmlNode jjtGetParent() {
        org.w3c.dom.Node parent = this.node.getParentNode();
        return parent != null ? this.parser.wrapDomNode(parent) : null;
    }

    public void jjtAddChild(Node child, int index) {
        throw new UnsupportedOperationException();
    }

    public void jjtSetChildIndex(int index) {
        throw new UnsupportedOperationException();
    }

    public int jjtGetChildIndex() {
        org.w3c.dom.Node parent = this.node.getParentNode();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (this.node != childNodes.item(i)) continue;
            return i;
        }
        throw new IllegalStateException("This node is not a child of its parent: " + this.node);
    }

    public XmlNode jjtGetChild(int index) {
        return this.parser.wrapDomNode(this.node.getChildNodes().item(index));
    }

    public int jjtGetNumChildren() {
        return this.node.hasChildNodes() ? this.node.getChildNodes().getLength() : 0;
    }

    public int jjtGetId() {
        return 0;
    }

    public String getImage() {
        return this.node instanceof Text ? ((Text)this.node).getData() : null;
    }

    public void setImage(String image) {
        throw new UnsupportedOperationException();
    }

    public boolean hasImageEqualTo(String image) {
        return Objects.equals(image, this.getImage());
    }

    public int getBeginLine() {
        return (Integer)this.getUserData("pmd:beginLine");
    }

    public int getBeginColumn() {
        return (Integer)this.getUserData("pmd:beginColumn");
    }

    public int getEndLine() {
        return (Integer)this.getUserData("pmd:endLine");
    }

    public int getEndColumn() {
        return (Integer)this.getUserData("pmd:endColumn");
    }

    public DataFlowNode getDataFlowNode() {
        throw new UnsupportedOperationException();
    }

    public void setDataFlowNode(DataFlowNode dataFlowNode) {
        throw new UnsupportedOperationException();
    }

    public boolean isFindBoundary() {
        return false;
    }

    public Document getAsDocument() {
        throw new UnsupportedOperationException();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void removeChildAtIndex(int childIndex) {
        throw new UnsupportedOperationException();
    }

    public String getXPathNodeName() {
        return this.node.getNodeName().replace("#", "");
    }

    public String toString() {
        return this.node.getNodeName().replace("#", "");
    }

    public Iterator<Attribute> getXPathAttributesIterator() {
        ArrayList<Iterator<Attribute>> iterators = new ArrayList<Iterator<Attribute>>();
        final NamedNodeMap attributes = this.node.getAttributes();
        iterators.add(new Iterator<Attribute>(){
            private int index;

            @Override
            public boolean hasNext() {
                return attributes != null && this.index < attributes.getLength();
            }

            @Override
            public Attribute next() {
                org.w3c.dom.Node attributeNode = attributes.item(this.index++);
                return new Attribute((Node)XmlNodeWrapper.this, attributeNode.getNodeName(), attributeNode.getNodeValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        if (this.node instanceof Text) {
            iterators.add(Collections.singletonList(new Attribute((Node)this, "Image", ((Text)this.node).getData())).iterator());
        }
        Iterator[] it = new Iterator[iterators.size()];
        return new CompoundIterator(iterators.toArray(it));
    }

    @Deprecated
    public Iterator<Attribute> getAttributeIterator() {
        return this.getXPathAttributesIterator();
    }

    @Override
    public org.w3c.dom.Node getNode() {
        return this.node;
    }
}

