/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.impl.AttributeAxisIterator;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.internal.DOMLineNumbers;
import net.sourceforge.pmd.lang.xml.ast.internal.XmlNodeWrapper;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlParserImpl {
    private static final EntityResolver SILENT_ENTITY_RESOLVER = (publicId, systemId) -> new InputSource(new ByteArrayInputStream("".getBytes()));
    private final Map<org.w3c.dom.Node, XmlNode> nodeCache = new HashMap<org.w3c.dom.Node, XmlNode>();

    private Document parseDocument(String xmlData) throws ParseException {
        this.nodeCache.clear();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(false);
            dbf.setExpandEntityReferences(true);
            dbf.setCoalescing(false);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            documentBuilder.setEntityResolver(SILENT_ENTITY_RESOLVER);
            return documentBuilder.parse(new InputSource(new StringReader(xmlData)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public RootXmlNode parse(Parser.ParserTask task) {
        String xmlData = task.getSourceText();
        Document document = this.parseDocument(xmlData);
        RootXmlNode root = new RootXmlNode(this, document, task);
        DOMLineNumbers lineNumbers = new DOMLineNumbers(root, task.getTextDocument());
        lineNumbers.determine();
        this.nodeCache.put(document, root);
        return root;
    }

    XmlNode wrapDomNode(org.w3c.dom.Node domNode) {
        XmlNode wrapper = this.nodeCache.get(domNode);
        if (wrapper == null) {
            wrapper = new XmlNodeWrapper(this, domNode);
            this.nodeCache.put(domNode, wrapper);
        }
        return wrapper;
    }

    public static class RootXmlNode
    extends XmlNodeWrapper
    implements RootNode {
        private final AstInfo<RootXmlNode> astInfo;

        RootXmlNode(XmlParserImpl parser, Document domNode, Parser.ParserTask task) {
            super(parser, domNode);
            this.astInfo = new AstInfo(task, (RootNode)this);
        }

        public AstInfo<RootXmlNode> getAstInfo() {
            return this.astInfo;
        }

        @Override
        public XmlNode wrap(org.w3c.dom.Node domNode) {
            return super.wrap(domNode);
        }

        @Override
        public Document getNode() {
            return (Document)super.getNode();
        }

        public String getXmlEncoding() {
            return this.getNode().getXmlEncoding();
        }

        public boolean isXmlStandalone() {
            return this.getNode().getXmlStandalone();
        }

        public String getXmlVersion() {
            return this.getNode().getXmlVersion();
        }

        @Override
        public Iterator<Attribute> getXPathAttributesIterator() {
            return new AttributeAxisIterator((Node)this);
        }
    }
}

