/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.rule;

import java.util.Objects;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.xml.ast.internal.XmlParserImpl;
import net.sourceforge.pmd.lang.xml.rule.SaxonDomXPathQuery;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.reporting.RuleContext;

public class DomXPathRule
extends AbstractRule {
    SaxonDomXPathQuery query;
    private static final PropertyDescriptor<String> XPATH_EXPR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"xpath").desc("An XPath 2.0 expression that will be evaluated against the root DOM")).defaultValue((Object)"")).build();
    private static final PropertyDescriptor<String> DEFAULT_NS_URI = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"defaultNsUri").desc("A URI for the default namespace of node tests in the XPath expression.This is provided to match documents based on their declared schema.")).defaultValue((Object)"")).build();

    public DomXPathRule() {
        this.definePropertyDescriptor(XPATH_EXPR);
        this.definePropertyDescriptor(DEFAULT_NS_URI);
    }

    public DomXPathRule(String xpath) {
        this(xpath, "");
    }

    public DomXPathRule(String xpath, String defaultNsUri) {
        this();
        this.setProperty(XPATH_EXPR, xpath);
        this.setProperty(DEFAULT_NS_URI, defaultNsUri);
    }

    public void apply(Node node, RuleContext ctx) {
        XmlParserImpl.RootXmlNode root = (XmlParserImpl.RootXmlNode)node;
        SaxonDomXPathQuery query = this.getXPathQuery();
        for (Node foundNode : query.evaluate(root, (PropertySource)this)) {
            ctx.addViolation(foundNode);
        }
    }

    public void initialize(LanguageProcessor languageProcessor) {
        this.query = new SaxonDomXPathQuery((String)this.getProperty(XPATH_EXPR), (String)this.getProperty(DEFAULT_NS_URI), this.getPropertyDescriptors(), languageProcessor.services().getXPathHandler());
    }

    private SaxonDomXPathQuery getXPathQuery() {
        return Objects.requireNonNull(this.query, "rule not initialized");
    }
}

