/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.xml.ast.internal.XmlNodeWrapper;
import net.sourceforge.pmd.lang.xml.ast.internal.XmlParserImpl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

class DOMLineNumbers {
    private final XmlParserImpl.RootXmlNode document;
    private final TextDocument textDocument;
    private Chars xmlString;

    DOMLineNumbers(XmlParserImpl.RootXmlNode root, TextDocument textDocument) {
        this.document = root;
        this.xmlString = textDocument.getText();
        this.textDocument = textDocument;
    }

    void determine() {
        this.determineLocation(this.document, 0);
    }

    private int determineLocation(XmlNodeWrapper wrapper, int index) {
        boolean isAutoClose;
        int nextIndex = index;
        int nodeLength = 0;
        int textLength = 0;
        Node n = wrapper.getNode();
        if (n.getNodeType() == 10) {
            nextIndex = this.xmlString.indexOf("<!DOCTYPE", nextIndex);
        } else if (n.getNodeType() == 8) {
            nextIndex = this.xmlString.indexOf("<!--", nextIndex);
        } else if (n.getNodeType() == 1) {
            nextIndex = this.xmlString.indexOf("<" + n.getNodeName(), nextIndex);
            nodeLength = this.xmlString.indexOf(">", nextIndex) - nextIndex + 1;
        } else if (n.getNodeType() == 4) {
            nextIndex = this.xmlString.indexOf("<![CDATA[", nextIndex);
        } else if (n.getNodeType() == 7) {
            ProcessingInstruction pi = (ProcessingInstruction)n;
            nextIndex = this.xmlString.indexOf("<?" + pi.getTarget(), nextIndex);
        } else if (n.getNodeType() == 3) {
            String te = this.unexpandEntities(n, n.getNodeValue(), true);
            int newIndex = this.xmlString.indexOf(te, nextIndex);
            if (newIndex == -1) {
                te = this.unexpandEntities(n, n.getNodeValue(), false);
                newIndex = this.xmlString.indexOf(te, nextIndex);
            }
            if (newIndex > 0) {
                textLength = te.length();
                nextIndex = newIndex;
            }
        } else if (n.getNodeType() == 5) {
            nextIndex = this.xmlString.indexOf("&" + n.getNodeName() + ";", nextIndex);
        }
        this.setBeginLocation(wrapper, nextIndex);
        nextIndex += nodeLength;
        if (n.hasChildNodes()) {
            int numChildren = wrapper.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                nextIndex = this.determineLocation((XmlNodeWrapper)wrapper.getChild(i), nextIndex);
            }
        }
        boolean bl = isAutoClose = !n.hasChildNodes() && n.getNodeType() == 1 && this.xmlString.startsWith("/>", nextIndex - 2);
        if (n.getNodeType() == 1 && !isAutoClose) {
            nextIndex += 2 + n.getNodeName().length() + 1;
        } else if (n.getNodeType() == 10) {
            Node nextSibling = n.getNextSibling();
            nextIndex = nextSibling.getNodeType() == 1 ? this.xmlString.indexOf("<" + nextSibling.getNodeName(), nextIndex) - 1 : (nextSibling.getNodeType() == 8 ? this.xmlString.indexOf("<!--", nextIndex) : this.xmlString.indexOf(">", nextIndex));
        } else if (n.getNodeType() == 8) {
            nextIndex += 7;
            nextIndex += n.getNodeValue().length();
        } else if (n.getNodeType() == 3) {
            nextIndex += textLength;
        } else if (n.getNodeType() == 4) {
            nextIndex += "<![CDATA[".length() + n.getNodeValue().length() + "]]>".length();
        } else if (n.getNodeType() == 7) {
            ProcessingInstruction pi = (ProcessingInstruction)n;
            nextIndex += "<?".length() + pi.getTarget().length() + "?>".length() + pi.getData().length();
        }
        this.setEndLocation(wrapper, nextIndex - 1);
        return nextIndex;
    }

    private String unexpandEntities(Node n, String te, boolean withQuotes) {
        String result = te;
        DocumentType doctype = n.getOwnerDocument().getDoctype();
        result = result.replaceAll(Matcher.quoteReplacement("&"), "&amp;");
        result = result.replaceAll(Matcher.quoteReplacement("<"), "&lt;");
        result = result.replaceAll(Matcher.quoteReplacement(">"), "&gt;");
        if (withQuotes) {
            result = result.replaceAll(Matcher.quoteReplacement("\""), "&quot;");
            result = result.replaceAll(Matcher.quoteReplacement("'"), "&apos;");
        }
        if (doctype != null) {
            NamedNodeMap entities = doctype.getEntities();
            String internalSubset = doctype.getInternalSubset();
            if (internalSubset == null) {
                internalSubset = "";
            }
            for (int i = 0; i < entities.getLength(); ++i) {
                Node item = entities.item(i);
                String entityName = item.getNodeName();
                Node firstChild = item.getFirstChild();
                if (firstChild != null) {
                    result = result.replaceAll(Matcher.quoteReplacement(firstChild.getNodeValue()), "&" + entityName + ";");
                    continue;
                }
                Matcher m = Pattern.compile(Matcher.quoteReplacement("<!ENTITY " + entityName + " ") + "[']([^']*)[']>").matcher(internalSubset);
                if (!m.find()) continue;
                result = result.replaceAll(Matcher.quoteReplacement(m.group(1)), "&" + entityName + ";");
            }
        }
        return result;
    }

    private void setBeginLocation(XmlNodeWrapper n, int index) {
        if (n != null) {
            n.startOffset = index;
            n.textDoc = this.textDocument;
        }
    }

    private void setEndLocation(XmlNodeWrapper n, int index) {
        if (n != null) {
            n.endOffset = index;
        }
    }
}

