/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java9.util.DoubleSummaryStatistics;
import java9.util.Objects;
import java9.util.OptionalDouble;
import java9.util.PrimitiveIterator;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.function.BiConsumer;
import java9.util.function.BinaryOperator;
import java9.util.function.DoubleBinaryOperator;
import java9.util.function.DoubleConsumer;
import java9.util.function.DoubleFunction;
import java9.util.function.DoublePredicate;
import java9.util.function.DoubleToIntFunction;
import java9.util.function.DoubleToLongFunction;
import java9.util.function.DoubleUnaryOperator;
import java9.util.function.IntFunction;
import java9.util.function.ObjDoubleConsumer;
import java9.util.function.Supplier;
import java9.util.stream.AbstractPipeline;
import java9.util.stream.BaseStream;
import java9.util.stream.Collectors;
import java9.util.stream.DoubleStream;
import java9.util.stream.FindOps;
import java9.util.stream.ForEachOps;
import java9.util.stream.IntPipeline;
import java9.util.stream.IntStream;
import java9.util.stream.LongPipeline;
import java9.util.stream.LongStream;
import java9.util.stream.MatchOps;
import java9.util.stream.Node;
import java9.util.stream.Nodes;
import java9.util.stream.PipelineHelper;
import java9.util.stream.ReduceOps;
import java9.util.stream.ReferencePipeline;
import java9.util.stream.Sink;
import java9.util.stream.SliceOps;
import java9.util.stream.SortedOps;
import java9.util.stream.Stream;
import java9.util.stream.StreamOpFlag;
import java9.util.stream.StreamShape;
import java9.util.stream.StreamSpliterators;
import java9.util.stream.WhileOps;

abstract class DoublePipeline<E_IN>
extends AbstractPipeline<E_IN, Double, DoubleStream>
implements DoubleStream {
    DoublePipeline(Supplier<? extends Spliterator<Double>> source, int sourceFlags, boolean parallel) {
        super(source, sourceFlags, parallel);
    }

    DoublePipeline(Spliterator<Double> source, int sourceFlags, boolean parallel) {
        super(source, sourceFlags, parallel);
    }

    DoublePipeline(AbstractPipeline<?, E_IN, ?> upstream, int opFlags) {
        super(upstream, opFlags);
    }

    private static DoubleConsumer adapt(Sink<Double> sink) {
        if (sink instanceof DoubleConsumer) {
            return (DoubleConsumer)((Object)sink);
        }
        return sink::accept;
    }

    private static Spliterator.OfDouble adapt(Spliterator<Double> s) {
        if (s instanceof Spliterator.OfDouble) {
            return (Spliterator.OfDouble)s;
        }
        throw new UnsupportedOperationException("DoubleStream.adapt(Spliterator<Double> s)");
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.DOUBLE_VALUE;
    }

    @Override
    final <P_IN> Node<Double> evaluateToNode(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator, boolean flattenTree, IntFunction<Double[]> generator) {
        return Nodes.collectDouble(helper, spliterator, flattenTree);
    }

    @Override
    final <P_IN> Spliterator<Double> wrap(PipelineHelper<Double> ph, Supplier<Spliterator<P_IN>> supplier, boolean isParallel) {
        return new StreamSpliterators.DoubleWrappingSpliterator<P_IN>(ph, supplier, isParallel);
    }

    final Spliterator.OfDouble lazySpliterator(Supplier<? extends Spliterator<Double>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator.OfDouble((Supplier<Spliterator.OfDouble>)supplier);
    }

    @Override
    final boolean forEachWithCancel(Spliterator<Double> spliterator, Sink<Double> sink) {
        boolean cancelled;
        Spliterator.OfDouble spl = DoublePipeline.adapt(spliterator);
        DoubleConsumer adaptedSink = DoublePipeline.adapt(sink);
        while (!(cancelled = sink.cancellationRequested()) && spl.tryAdvance(adaptedSink)) {
        }
        return cancelled;
    }

    @Override
    final Node.Builder<Double> makeNodeBuilder(long exactSizeIfKnown, IntFunction<Double[]> generator) {
        return Nodes.doubleBuilder(exactSizeIfKnown);
    }

    private <U> Stream<U> mapToObj(final DoubleFunction<? extends U> mapper, int opFlags) {
        return new ReferencePipeline.StatelessOp<Double, U>(this, StreamShape.DOUBLE_VALUE, opFlags){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<U> sink) {
                return new Sink.ChainedDouble<U>(sink){

                    @Override
                    public void accept(double t) {
                        this.downstream.accept(mapper.apply(t));
                    }
                };
            }
        };
    }

    @Override
    public final PrimitiveIterator.OfDouble iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfDouble spliterator() {
        return DoublePipeline.adapt(super.spliterator());
    }

    @Override
    public final Stream<Double> boxed() {
        return this.mapToObj(Double::valueOf, 0);
    }

    @Override
    public final DoubleStream map(final DoubleUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void accept(double t) {
                        this.downstream.accept(mapper.applyAsDouble(t));
                    }
                };
            }
        };
    }

    @Override
    public final <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.mapToObj(mapper, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT);
    }

    @Override
    public final IntStream mapToInt(final DoubleToIntFunction mapper) {
        Objects.requireNonNull(mapper);
        return new IntPipeline.StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedDouble<Integer>(sink){

                    @Override
                    public void accept(double t) {
                        this.downstream.accept(mapper.applyAsInt(t));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapToLong(final DoubleToLongFunction mapper) {
        Objects.requireNonNull(mapper);
        return new LongPipeline.StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedDouble<Long>(sink){

                    @Override
                    public void accept(double t) {
                        this.downstream.accept(mapper.applyAsLong(t));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream flatMap(final DoubleFunction<? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){
                    boolean cancellationRequested;
                    DoubleConsumer downstreamAsDouble;
                    {
                        this.downstreamAsDouble = this.downstream::accept;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(double t) {
                        try (BaseStream result = null;){
                            result = (DoubleStream)mapper.apply(t);
                            if (result != null) {
                                if (!this.cancellationRequested) {
                                    result.sequential().forEach(this.downstreamAsDouble);
                                } else {
                                    Spliterator.OfDouble s = result.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s.tryAdvance(this.downstreamAsDouble)) {
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequested = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public DoubleStream unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return sink;
            }
        };
    }

    @Override
    public final DoubleStream filter(final DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(double t) {
                        if (predicate.test(t)) {
                            this.downstream.accept(t);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream peek(final DoubleConsumer action) {
        Objects.requireNonNull(action);
        return new StatelessOp<Double>((AbstractPipeline)this, StreamShape.DOUBLE_VALUE, 0){

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){

                    @Override
                    public void accept(double t) {
                        action.accept(t);
                        this.downstream.accept(t);
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        return SliceOps.makeDouble(this, 0L, maxSize);
    }

    @Override
    public final DoubleStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        if (n == 0L) {
            return this;
        }
        long limit = -1L;
        return SliceOps.makeDouble(this, n, limit);
    }

    @Override
    public final DoubleStream takeWhile(DoublePredicate predicate) {
        return WhileOps.makeTakeWhileDouble(this, predicate);
    }

    @Override
    public final DoubleStream dropWhile(DoublePredicate predicate) {
        return WhileOps.makeDropWhileDouble(this, predicate);
    }

    @Override
    public final DoubleStream sorted() {
        return SortedOps.makeDouble(this);
    }

    @Override
    public final DoubleStream distinct() {
        return this.boxed().distinct().mapToDouble(i -> i);
    }

    @Override
    public void forEach(DoubleConsumer consumer) {
        this.evaluate(ForEachOps.makeDouble(consumer, false));
    }

    @Override
    public void forEachOrdered(DoubleConsumer consumer) {
        this.evaluate(ForEachOps.makeDouble(consumer, true));
    }

    @Override
    public final double sum() {
        double[] summation = this.collect(() -> new double[3], (ll, d) -> {
            Collectors.sumWithCompensation(ll, d);
            ll[2] = ll[2] + d;
        }, (ll, rr) -> {
            Collectors.sumWithCompensation(ll, rr[0]);
            Collectors.sumWithCompensation(ll, rr[1]);
            ll[2] = ll[2] + rr[2];
        });
        return Collectors.computeFinalSum(summation);
    }

    @Override
    public final OptionalDouble min() {
        return this.reduce(Math::min);
    }

    @Override
    public final OptionalDouble max() {
        return this.reduce(Math::max);
    }

    @Override
    public final OptionalDouble average() {
        double[] avg = this.collect(() -> new double[4], (ll, d) -> {
            ll[2] = ll[2] + 1.0;
            Collectors.sumWithCompensation(ll, d);
            ll[3] = ll[3] + d;
        }, (ll, rr) -> {
            Collectors.sumWithCompensation(ll, rr[0]);
            Collectors.sumWithCompensation(ll, rr[1]);
            ll[2] = ll[2] + rr[2];
            ll[3] = ll[3] + rr[3];
        });
        return avg[2] > 0.0 ? OptionalDouble.of(Collectors.computeFinalSum(avg) / avg[2]) : OptionalDouble.empty();
    }

    @Override
    public final long count() {
        return this.evaluate(ReduceOps.makeDoubleCounting());
    }

    @Override
    public final DoubleSummaryStatistics summaryStatistics() {
        return this.collect(Collectors.DBL_SUM_STATS, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public final double reduce(double identity, DoubleBinaryOperator op) {
        return this.evaluate(ReduceOps.makeDouble(identity, op));
    }

    @Override
    public final OptionalDouble reduce(DoubleBinaryOperator op) {
        return this.evaluate(ReduceOps.makeDouble(op));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(combiner);
        BinaryOperator operator = (left, right) -> {
            combiner.accept(left, right);
            return left;
        };
        return this.evaluate(ReduceOps.makeDouble(supplier, accumulator, operator));
    }

    @Override
    public final boolean anyMatch(DoublePredicate predicate) {
        return this.evaluate(MatchOps.makeDouble(predicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(DoublePredicate predicate) {
        return this.evaluate(MatchOps.makeDouble(predicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(DoublePredicate predicate) {
        return this.evaluate(MatchOps.makeDouble(predicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final OptionalDouble findFirst() {
        return this.evaluate(FindOps.makeDouble(true));
    }

    @Override
    public final OptionalDouble findAny() {
        return this.evaluate(FindOps.makeDouble(false));
    }

    @Override
    public final double[] toArray() {
        return (double[])Nodes.flattenDouble((Node.OfDouble)this.evaluateToArrayNode(WhileOps.DOUBLE_ARR_GEN)).asPrimitiveArray();
    }

    static abstract class StatefulOp<E_IN>
    extends DoublePipeline<E_IN> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> var1, Spliterator<P_IN> var2, IntFunction<Double[]> var3);
    }

    static abstract class StatelessOp<E_IN>
    extends DoublePipeline<E_IN> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN>
    extends DoublePipeline<E_IN> {
        Head(Supplier<? extends Spliterator<Double>> source, int sourceFlags, boolean parallel) {
            super(source, sourceFlags, parallel);
        }

        Head(Spliterator<Double> source, int sourceFlags, boolean parallel) {
            super(source, sourceFlags, parallel);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int flags, Sink<Double> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(DoubleConsumer consumer) {
            if (!this.isParallel()) {
                DoublePipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(consumer);
            } else {
                super.forEach(consumer);
            }
        }

        @Override
        public void forEachOrdered(DoubleConsumer consumer) {
            if (!this.isParallel()) {
                DoublePipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(consumer);
            } else {
                super.forEachOrdered(consumer);
            }
        }
    }
}

