/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java9.util.DoubleSummaryStatistics;
import java9.util.J8Arrays;
import java9.util.Objects;
import java9.util.OptionalDouble;
import java9.util.PrimitiveIterator;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.function.BiConsumer;
import java9.util.function.DoubleBinaryOperator;
import java9.util.function.DoubleConsumer;
import java9.util.function.DoubleFunction;
import java9.util.function.DoublePredicate;
import java9.util.function.DoubleSupplier;
import java9.util.function.DoubleToIntFunction;
import java9.util.function.DoubleToLongFunction;
import java9.util.function.DoubleUnaryOperator;
import java9.util.function.ObjDoubleConsumer;
import java9.util.function.Supplier;
import java9.util.stream.BaseStream;
import java9.util.stream.IntStream;
import java9.util.stream.LongStream;
import java9.util.stream.Stream;
import java9.util.stream.StreamSpliterators;
import java9.util.stream.StreamSupport;
import java9.util.stream.Streams;
import java9.util.stream.WhileOps;

public interface DoubleStream
extends BaseStream<Double, DoubleStream> {
    public DoubleStream filter(DoublePredicate var1);

    public DoubleStream map(DoubleUnaryOperator var1);

    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> var1);

    public IntStream mapToInt(DoubleToIntFunction var1);

    public LongStream mapToLong(DoubleToLongFunction var1);

    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> var1);

    public DoubleStream distinct();

    public DoubleStream sorted();

    public DoubleStream peek(DoubleConsumer var1);

    public DoubleStream limit(long var1);

    public DoubleStream skip(long var1);

    default public DoubleStream takeWhile(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return (DoubleStream)StreamSupport.doubleStream(new WhileOps.UnorderedWhileSpliterator.OfDouble.Taking(this.spliterator(), true, predicate), this.isParallel()).onClose(StreamSupport.closeHandler(this));
    }

    default public DoubleStream dropWhile(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return (DoubleStream)StreamSupport.doubleStream(new WhileOps.UnorderedWhileSpliterator.OfDouble.Dropping(this.spliterator(), true, predicate), this.isParallel()).onClose(StreamSupport.closeHandler(this));
    }

    public void forEach(DoubleConsumer var1);

    public void forEachOrdered(DoubleConsumer var1);

    public double[] toArray();

    public double reduce(double var1, DoubleBinaryOperator var3);

    public OptionalDouble reduce(DoubleBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjDoubleConsumer<R> var2, BiConsumer<R, R> var3);

    public double sum();

    public OptionalDouble min();

    public OptionalDouble max();

    public long count();

    public OptionalDouble average();

    public DoubleSummaryStatistics summaryStatistics();

    public boolean anyMatch(DoublePredicate var1);

    public boolean allMatch(DoublePredicate var1);

    public boolean noneMatch(DoublePredicate var1);

    public OptionalDouble findFirst();

    public OptionalDouble findAny();

    public Stream<Double> boxed();

    @Override
    public DoubleStream sequential();

    @Override
    public DoubleStream parallel();

    public PrimitiveIterator.OfDouble iterator();

    public Spliterator.OfDouble spliterator();

    public static Builder builder() {
        return new Streams.DoubleStreamBuilderImpl();
    }

    public static DoubleStream empty() {
        return StreamSupport.doubleStream(Spliterators.emptyDoubleSpliterator(), false);
    }

    public static DoubleStream of(double t) {
        return StreamSupport.doubleStream(new Streams.DoubleStreamBuilderImpl(t), false);
    }

    public static DoubleStream of(double ... values) {
        return J8Arrays.stream(values);
    }

    public static DoubleStream iterate(final double seed, final DoubleUnaryOperator f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1296){
            double prev;
            boolean started;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.started) {
                    t = f.applyAsDouble(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public static DoubleStream iterate(final double seed, final DoublePredicate hasNext, final DoubleUnaryOperator next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1296){
            double prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = next.applyAsDouble(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!hasNext.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(DoubleConsumer action) {
                double t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                double d = t = this.started ? next.applyAsDouble(this.prev) : seed;
                while (hasNext.test(t)) {
                    action.accept(t);
                    t = next.applyAsDouble(t);
                }
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public static DoubleStream generate(DoubleSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.doubleStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfDouble(Long.MAX_VALUE, s), false);
    }

    public static DoubleStream concat(DoubleStream a, DoubleStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfDouble split = new Streams.ConcatSpliterator.OfDouble(a.spliterator(), b.spliterator());
        DoubleStream stream = StreamSupport.doubleStream(split, a.isParallel() || b.isParallel());
        return (DoubleStream)stream.onClose(Streams.composedClose(a, b));
    }

    public static interface Builder
    extends DoubleConsumer {
        @Override
        public void accept(double var1);

        default public Builder add(double t) {
            this.accept(t);
            return this;
        }

        public DoubleStream build();
    }
}

