/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall;

import net.sourceforge.wurfl.core.MarkUp;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagUtil {
    private static final Log log = LogFactory.getLog((Class)TagUtil.class);

    public static StrBuilder appendAttribute(StrBuilder handlers, String name, Object value) {
        if (StringUtils.isNotBlank((String)ObjectUtils.toString((Object)value))) {
            if (log.isTraceEnabled()) {
                StrBuilder logBuilder = new StrBuilder();
                logBuilder.append("Setting ").append(name).append(" attribute to value: ").append(value);
                log.trace((Object)logBuilder.toString());
            }
            handlers.append(" ");
            handlers.append(name);
            handlers.append("=\"");
            handlers.append(value);
            handlers.append("\"");
        }
        return handlers;
    }

    public static StrBuilder appendText(StrBuilder tagBuilder, String text) {
        if (StringUtils.isNotBlank((String)text)) {
            tagBuilder.append(text);
        }
        return tagBuilder;
    }

    public static String normalizeHref(String href, MarkUp markup) {
        String changedHref = href;
        if (markup.equals(MarkUp.CHTML)) {
            if (href.indexOf("&amp;") != -1) {
                changedHref = href.replaceAll("&amp;", "&");
            }
        } else if ((MarkUp.XHTML_ADVANCED.equals(markup) || MarkUp.XHTML_SIMPLE.equals(markup)) && href.indexOf("&amp;") == -1 && href.indexOf("&") != -1) {
            changedHref = href.replaceAll("&", "&amp;");
        }
        if (log.isTraceEnabled() && !changedHref.equals(href)) {
            log.trace((Object)("\"href\": " + href + " has changed in: " + href));
        }
        return changedHref;
    }

    public static String getEmoji(String ak, String region) {
        if (region.equals("eu")) {
            if (ak.equals("0")) {
                return "&#59115;";
            }
            if (ak.equals("1")) {
                return "&#59106;";
            }
            if (ak.equals("2")) {
                return "&#59107;";
            }
            if (ak.equals("3")) {
                return "&#59108;";
            }
            if (ak.equals("4")) {
                return "&#59109;";
            }
            if (ak.equals("5")) {
                return "&#59110;";
            }
            if (ak.equals("6")) {
                return "&#59111;";
            }
            if (ak.equals("7")) {
                return "&#59112;";
            }
            if (ak.equals("8")) {
                return "&#59113;";
            }
            if (ak.equals("9")) {
                return "&#59114;";
            }
        }
        if (region.equals("ja")) {
            if (ak.equals("1")) {
                return "&#63879;";
            }
            if (ak.equals("2")) {
                return "&#63880;";
            }
            if (ak.equals("3")) {
                return "&#63881;";
            }
            if (ak.equals("4")) {
                return "&#63882;";
            }
            if (ak.equals("5")) {
                return "&#63883;";
            }
            if (ak.equals("6")) {
                return "&#63884;";
            }
            if (ak.equals("7")) {
                return "&#63885;";
            }
            if (ak.equals("8")) {
                return "&#63886;";
            }
            if (ak.equals("9")) {
                return "&#63887;";
            }
            if (ak.equals("0")) {
                return "&#63888;";
            }
        }
        log.warn((Object)"unrecognized CHTML/Imode devices get the number");
        return ak;
    }
}

