/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import net.sourceforge.wurfl.wall.WallTag;
import org.apache.commons.lang.StringUtils;

public class WallDocument
extends WallTag {
    private static final long serialVersionUID = 10L;
    private boolean disable_wml_extensions;
    private boolean disable_xhtml_extensions;
    private boolean disable_cache;
    private boolean disable_content_type_generation;
    private boolean scriptInserted = false;
    private boolean styleInserted = false;
    private boolean enforceTitle;
    private String title;

    public int generateStartTag() throws JspException, IOException {
        this.configureContentType();
        this.disableCache();
        this.pageContext.setAttribute("device", (Object)this.getDevice());
        String documentStartTag = this.getTagsHandler().generateDocumentStartTag(this);
        this.pageContext.getOut().print(documentStartTag);
        return 1;
    }

    public int generateEndTag() throws JspException, IOException {
        String documentTag = this.getTagsHandler().generateDocumentEndTag(this);
        this.pageContext.getOut().print(documentTag);
        return 6;
    }

    public void release() {
        super.release();
        this.reset();
    }

    protected void reset() {
        super.reset();
        this.scriptInserted = false;
        this.styleInserted = false;
        this.enforceTitle = false;
        this.title = null;
    }

    protected void checkPosition() {
    }

    public boolean isScriptInserted() {
        return this.scriptInserted;
    }

    public void setScriptInserted(boolean scriptInserted) {
        this.scriptInserted = scriptInserted;
    }

    public boolean isStyleInserted() {
        return this.styleInserted;
    }

    public void setStyleInserted(boolean styleInserted) {
        this.styleInserted = styleInserted;
    }

    public boolean isEnforceTitle() {
        return this.enforceTitle;
    }

    public void setEnforceTitle(boolean enforceTitle) {
        this.enforceTitle = enforceTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isUseXhtmlExtensions() {
        return !this.disable_xhtml_extensions && this.getDevice().isOpenwaveXhtmExtensionSupported() && this.getDevice().isUpLink();
    }

    public boolean isUseWmlExtensions() {
        return !this.disable_wml_extensions && this.getDevice().isOpenwaveWmlExtensionSupported() && this.getDevice().isUpLink();
    }

    public boolean isUseOpenWaveExtension() {
        return this.isUseWmlExtensions() || this.isUseXhtmlExtensions();
    }

    public boolean isDisableWmlExtensions() {
        return this.disable_wml_extensions;
    }

    public void setDisableWmlExtensions(boolean disableWmlExtensions) {
        this.disable_wml_extensions = disableWmlExtensions;
    }

    public boolean isDisableXhtmlExtensions() {
        return this.disable_xhtml_extensions;
    }

    public void setDisableXhtmlExtensions(boolean disableXhtmlExtensions) {
        this.disable_xhtml_extensions = disableXhtmlExtensions;
    }

    public boolean isDisableCache() {
        return this.disable_cache;
    }

    public void setDisableCache(boolean disableCache) {
        this.disable_cache = disableCache;
    }

    public boolean isDisableContentTypeGeneration() {
        return this.disable_content_type_generation;
    }

    public void setDisableContentTypeGeneration(boolean disableContentTypeGeneration) {
        this.disable_content_type_generation = disableContentTypeGeneration;
    }

    protected void disableCache() {
        if (this.disable_cache) {
            HttpServletResponse httpResponse = (HttpServletResponse)this.pageContext.getResponse();
            httpResponse.addHeader("Cache-Control", "no-cache, must-revalidate");
            httpResponse.addHeader("Pragma", "no-cache");
            httpResponse.setHeader("Expires", "Sun, 12 Jul 1970 2:00:00 GMT");
        }
    }

    protected void configureContentType() {
        String contentType;
        if (!this.disable_content_type_generation && StringUtils.isNotBlank((String)(contentType = this.resolveMimeType()))) {
            this.pageContext.getResponse().setContentType(contentType);
        }
    }

    protected String resolveMimeType() {
        String contentType = "text/html";
        if (this.getDevice().isWml()) {
            contentType = "text/vnd.wap.wml";
        } else if (this.getDevice().isXhtml()) {
            contentType = this.getDevice().getXhtmlPreferredMimeType();
        }
        return contentType;
    }
}

