/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import net.sourceforge.wurfl.wall.context.WallDevice;
import net.sourceforge.wurfl.wall.render.TagsHandler;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WallTag
extends BodyTagSupport {
    private static final long serialVersionUID = 10L;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public int doStartTag() throws JspException {
        this.checkAttributes();
        this.checkPosition();
        this.configureParent();
        int returnValue = 0;
        try {
            returnValue = this.generateStartTag();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new JspTagException(ex.getMessage());
        }
        return returnValue;
    }

    public int doEndTag() throws JspException {
        int returnValue = 6;
        try {
            returnValue = this.generateEndTag();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new JspTagException(ex.getMessage());
        }
        this.reset();
        return returnValue;
    }

    protected void reset() {
        this.log.trace((Object)("Tag: " + this.getId() + " resetted."));
    }

    public void release() {
        super.release();
        this.reset();
        this.log.trace((Object)("Tag: " + this.getId() + " released."));
    }

    public final boolean isSessionEnabled() {
        return BooleanUtils.toBoolean((Boolean)((Boolean)this.pageContext.findAttribute("sessionEnabled")));
    }

    public final WallDevice getDevice() {
        return (WallDevice)this.pageContext.findAttribute("device");
    }

    protected final TagsHandler getTagsHandler() {
        return (TagsHandler)this.pageContext.findAttribute("tagsHandler");
    }

    public abstract int generateStartTag() throws Exception;

    public abstract int generateEndTag() throws Exception;

    protected void checkPosition() {
    }

    protected void checkAttributes() {
    }

    protected void configureParent() {
    }
}

