/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.context;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.WURFLHolder;
import net.sourceforge.wurfl.core.WURFLManager;
import net.sourceforge.wurfl.core.request.DefaultUserAgentResolver;
import net.sourceforge.wurfl.core.request.UserAgentResolver;
import net.sourceforge.wurfl.wall.context.WallDevice;
import net.sourceforge.wurfl.wall.context.WurflWallDeviceDecorator;
import net.sourceforge.wurfl.wall.render.DefaultTagsHandlerFactory;
import net.sourceforge.wurfl.wall.render.TagsHandler;
import net.sourceforge.wurfl.wall.render.TagsHandlerFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WALLFilter
implements Filter {
    public static final String WURFL_HOLDER_KEY_PARAM = "wurflHolderKey";
    private final Log logger = LogFactory.getLog(this.getClass());
    private WURFLManager wurflManager;
    private boolean isSessionEnabled;
    private UserAgentResolver userAgentResolver;
    private TagsHandlerFactory defaultTagsHandlerFactory;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        this.handleRequest(httpRequest);
        chain.doFilter(request, response);
    }

    protected void handleRequest(HttpServletRequest request) {
        if (this.isSessionEnabled && request.getSession().getAttribute("device") == null) {
            WallDevice device = this.createDevice(request);
            TagsHandler tagsHandler = this.createTagsHandler(device);
            request.getSession().setAttribute("device", (Object)device);
            request.getSession().setAttribute("tagsHandler", (Object)tagsHandler);
        } else if (!this.isSessionEnabled) {
            WallDevice device = this.createDevice(request);
            TagsHandler tagsHandler = this.createTagsHandler(device);
            request.setAttribute("device", (Object)device);
            request.setAttribute("tagsHandler", (Object)tagsHandler);
        }
    }

    protected WallDevice createDevice(HttpServletRequest request) {
        Device device = this.wurflManager.getDeviceForRequest(request);
        boolean isUplink = this.isUplink(request);
        WurflWallDeviceDecorator wallDevice = new WurflWallDeviceDecorator(device, isUplink);
        return wallDevice;
    }

    private boolean isUplink(HttpServletRequest request) {
        String userAgent = this.userAgentResolver.resolve(request);
        return StringUtils.contains((String)userAgent, (String)"UP.Link");
    }

    protected TagsHandler createTagsHandler(WallDevice device) {
        return this.defaultTagsHandlerFactory.getInstance(device);
    }

    public void init(FilterConfig config) throws ServletException {
        this.initSession(config);
        this.defaultTagsHandlerFactory = this.createTagsHandlerFactory(config);
        this.logger.debug((Object)"TagsHandler created.");
        this.userAgentResolver = this.createUserAgentResolver(config);
        this.logger.debug((Object)"UserAgentResolver created.");
        this.wurflManager = this.createWurflManager(config);
        this.logger.debug((Object)"WURFLManager created.");
        this.logger.info((Object)"WALLFilter initialized.");
    }

    protected void initSession(FilterConfig config) {
        ServletContext applicationContext = config.getServletContext();
        this.isSessionEnabled = BooleanUtils.toBoolean((String)applicationContext.getInitParameter("session_enabled")) || BooleanUtils.toBoolean((String)config.getInitParameter("session_enabled"));
        applicationContext.setAttribute("sessionEnabled", (Object)new Boolean(this.isSessionEnabled));
    }

    protected UserAgentResolver createUserAgentResolver(FilterConfig config) {
        return new DefaultUserAgentResolver();
    }

    protected TagsHandlerFactory createTagsHandlerFactory(FilterConfig config) {
        return new DefaultTagsHandlerFactory();
    }

    protected WURFLManager createWurflManager(FilterConfig config) throws ServletException {
        WURFLHolder wurflHolder;
        ServletContext applicationContext = config.getServletContext();
        String wurflHolderKey = WURFLHolder.class.getName();
        if (!StringUtils.isEmpty((String)config.getInitParameter(WURFL_HOLDER_KEY_PARAM))) {
            wurflHolderKey = config.getInitParameter(WURFL_HOLDER_KEY_PARAM);
        }
        if ((wurflHolder = (WURFLHolder)applicationContext.getAttribute(wurflHolderKey)) == null) {
            throw new ServletException("The wurflHolder is not in servlet context, expected with key: " + wurflHolderKey);
        }
        this.logger.trace((Object)("WURFLHolder resolved using wurflHolderKey: " + wurflHolderKey + " isSessionEnabled: " + this.isSessionEnabled));
        return wurflHolder.getWURFLManager();
    }

    public void destroy() {
    }
}

