/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.context;

import java.io.Serializable;
import java.util.Map;
import net.sourceforge.wurfl.core.CapabilityNotDefinedException;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.core.MarkUp;
import net.sourceforge.wurfl.wall.context.WallDevice;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WurflWallDeviceDecorator
implements WallDevice,
Serializable {
    private static final long serialVersionUID = 10L;
    private static final Log log = LogFactory.getLog((Class)WurflWallDeviceDecorator.class);
    private final Device device;
    private final boolean upLink;

    public WurflWallDeviceDecorator(Device device, boolean upLink) {
        this.device = device;
        this.upLink = upLink;
    }

    public Map getCapabilities() {
        return this.device.getCapabilities();
    }

    public String getCapability(String name) throws CapabilityNotDefinedException {
        return this.device.getCapability(name);
    }

    public String getId() {
        return this.device.getId();
    }

    public MarkUp getMarkUp() {
        return this.device.getMarkUp();
    }

    public String getUserAgent() {
        return this.device.getUserAgent();
    }

    public boolean isUpLink() {
        return this.upLink;
    }

    public String getPreferredMarkup() {
        return this.device.getCapability("preferred_markup");
    }

    public boolean isChtml() {
        return StringUtils.contains((String)this.getPreferredMarkup(), (String)"imode");
    }

    public boolean isWml() {
        return StringUtils.contains((String)this.getPreferredMarkup(), (String)"wml");
    }

    public boolean isXhtml() {
        return StringUtils.contains((String)this.getPreferredMarkup(), (String)"html") && !StringUtils.contains((String)this.getPreferredMarkup(), (String)"imode");
    }

    public boolean isOpenwaveWmlExtensionSupported() {
        return BooleanUtils.toBoolean((String)this.device.getCapability("opwv_wml_extensions_support"));
    }

    public boolean isOpenwaveXhtmExtensionSupported() {
        return BooleanUtils.toBoolean((String)this.device.getCapability("opwv_xhtml_extensions_support"));
    }

    public boolean isOpenwaveExtensionSupported() {
        boolean supported = false;
        if (this.isWml()) {
            supported = this.isOpenwaveWmlExtensionSupported();
        } else if (this.isXhtml()) {
            supported = this.isOpenwaveXhtmExtensionSupported();
        }
        return supported;
    }

    public boolean isWmlTableSupported() {
        return BooleanUtils.toBoolean((String)this.device.getCapability("table_support"));
    }

    public boolean isChtmlTableSupported() {
        return BooleanUtils.toBoolean((String)this.device.getCapability("chtml_table_support"));
    }

    public boolean isXhtmlTableSupported() {
        return BooleanUtils.toBoolean((String)this.device.getCapability("xhtml_table_support"));
    }

    public boolean isTableSupported() {
        if (this.isXhtml()) {
            return this.isXhtmlTableSupported();
        }
        if (this.isChtml()) {
            return this.isChtmlTableSupported();
        }
        if (this.isWml()) {
            return this.isWmlTableSupported();
        }
        log.warn((Object)("Device : " + this.getId() + ", is identified as not wml,chtml or xhtml device."));
        return false;
    }

    public boolean isAccessKeySupported() {
        boolean supported = BooleanUtils.toBoolean((String)this.getCapability("access_key_support"));
        return supported;
    }

    public String getXhtmlPreferredMimeType() {
        return this.device.getCapability("xhtmlmp_preferred_mime_type");
    }
}

