/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.render;

import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.wall.TagUtil;
import net.sourceforge.wurfl.wall.WallA;
import net.sourceforge.wurfl.wall.WallB;
import net.sourceforge.wurfl.wall.WallBlock;
import net.sourceforge.wurfl.wall.WallBody;
import net.sourceforge.wurfl.wall.WallBr;
import net.sourceforge.wurfl.wall.WallCaller;
import net.sourceforge.wurfl.wall.WallCell;
import net.sourceforge.wurfl.wall.WallCool_menu;
import net.sourceforge.wurfl.wall.WallFont;
import net.sourceforge.wurfl.wall.WallHead;
import net.sourceforge.wurfl.wall.WallHr;
import net.sourceforge.wurfl.wall.WallImg;
import net.sourceforge.wurfl.wall.WallInput;
import net.sourceforge.wurfl.wall.WallMarquee;
import net.sourceforge.wurfl.wall.WallMenu;
import net.sourceforge.wurfl.wall.WallOption;
import net.sourceforge.wurfl.wall.WallXmlpidtd;
import net.sourceforge.wurfl.wall.render.DefaultWallTagsHandler;
import net.sourceforge.wurfl.wall.utils.MarkupBuilder;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChtmlTagsHandler
extends DefaultWallTagsHandler {
    private static final long serialVersionUID = 10L;
    private static final Pattern NUMERIC_FORMAT_PATTERN = Pattern.compile("[\\*|\\d]N|N{1,}");
    private final Log log = LogFactory.getLog(this.getClass());

    protected String generateAnchorDefaultStartTag(WallA a) {
        MarkupBuilder builder = new MarkupBuilder();
        builder.startOpenElement("a");
        builder.appendAttribute("href", a.getHref());
        builder.appendAttribute("accesskey", a.getAccesskey());
        builder.endOpenElement();
        return builder.toMarkup();
    }

    protected String generateAnchorMenuStartTag(WallA a) {
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)a, (Class)WallMenu.class);
        String region = this.getImodeRegion(a.getDevice());
        MarkupBuilder builder = new MarkupBuilder();
        String accessKey = null;
        accessKey = menu.isAutonumber() ? String.valueOf(a.getMenuIndex() + 1) : a.getAccesskey();
        if (StringUtils.isNotBlank((String)accessKey)) {
            String emoji = TagUtil.getEmoji(accessKey, region);
            builder.appendText(emoji).appendText("&nbsp;");
        }
        builder.startOpenElement("a");
        builder.appendAttribute("href", a.getHref());
        builder.appendAttribute("accesskey", accessKey);
        builder.endOpenElement();
        return builder.toMarkup();
    }

    protected String generateAnchorMenuEndTag(WallA a) {
        return "</a><br>";
    }

    public String generateBoldStartTag(WallB b) {
        return "";
    }

    public String generateBoldEndTag(WallB b) {
        return "";
    }

    public String generateBlockStartTag(WallBlock block) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (StringUtils.isNotBlank((String)block.getAlign())) {
            tagBuilder.startOpenElement("p");
            if (StringUtils.equals((String)block.getAlign(), (String)"middle")) {
                tagBuilder.appendAttribute("align", "center");
            } else {
                tagBuilder.appendAttribute("align", block.getAlign());
            }
            tagBuilder.endOpenElement();
        }
        return tagBuilder.toMarkup();
    }

    public String generateBlockEndTag(WallBlock blocks) {
        if (StringUtils.isNotBlank((String)blocks.getAlign())) {
            return "</p>";
        }
        return "";
    }

    public String generateBodyStartTag(WallBody body) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("body").appendAttribute("text", body.getText()).appendAttribute("bgcolor", body.getBgcolor()).endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateBrStartTag(WallBr br) {
        return "<br>";
    }

    protected String generateCallerDefaultStartTag(WallCaller tag) {
        MarkupBuilder builder = new MarkupBuilder();
        builder.startOpenElement("a");
        String callerPrefix = tag.getDevice().getCapability("chtml_make_phone_call_string");
        if (!StringUtils.equals((String)callerPrefix, (String)"none")) {
            String href = new StrBuilder(callerPrefix).append(tag.getTel()).toString();
            builder.appendAttribute("href", href);
            builder.appendAttribute("cti", tag.getCti());
            builder.appendAttribute("accesskey", tag.getAccesskey());
            builder.endOpenElement();
        } else {
            builder.appendAttribute("href", "#");
            builder.appendAttribute("accesskey", tag.getAccesskey());
            builder.endOpenElement();
            builder.appendText(tag.getAlt());
        }
        return builder.toMarkup();
    }

    protected String generateCallerMenuStartTag(WallCaller tag) {
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class);
        String region = this.getImodeRegion(tag.getDevice());
        MarkupBuilder builder = new MarkupBuilder();
        String accessKey = null;
        accessKey = menu.isAutonumber() ? String.valueOf(tag.getMenuIndex() + 1) : tag.getAccesskey();
        if (StringUtils.isNotBlank((String)accessKey)) {
            String emoji = TagUtil.getEmoji(accessKey, region);
            builder.appendText(emoji).appendText("&nbsp;");
        }
        builder.startOpenElement("a");
        String callerPrefix = tag.getDevice().getCapability("chtml_make_phone_call_string");
        if (!StringUtils.equals((String)callerPrefix, (String)"none")) {
            String href = new StrBuilder(callerPrefix).append(tag.getTel()).toString();
            builder.appendAttribute("href", href);
            builder.appendAttribute("cti", tag.getCti());
            builder.endOpenElement();
        } else {
            builder.appendAttribute("href", "#");
            builder.appendText(" ").appendText(tag.getAlt());
            builder.endOpenElement();
        }
        builder.appendAttribute("accesskey", accessKey);
        return builder.toMarkup();
    }

    protected String generateCallerMenuEndTag(WallCaller tag) {
        return "</a><br>";
    }

    protected String generateCellDefaultEndTag(WallCell cell) {
        return "<br>";
    }

    public String generateCoolMenuDefaultStartTag(WallCool_menu coolMenu) throws JspException {
        return "";
    }

    protected String generateCoolMenuDefaultEndTag(WallCool_menu coolMenu) {
        return "";
    }

    public String generateFontStartTag(WallFont font) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("font");
        tagBuilder.appendAttribute("color", font.getColor());
        tagBuilder.appendAttribute("face", font.getFace());
        tagBuilder.appendAttribute("size", font.getSize());
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateFontEndTag(WallFont font) {
        return "</font>";
    }

    public String generateHeadStartTag(WallHead head) {
        return new MarkupBuilder().openElement("html").appendNewLine().openElement("head").appendNewLine().toMarkup();
    }

    public String generateHrEndTag(WallHr hr) {
        return new MarkupBuilder().startOpenElement("hr").appendAttribute("color", hr.getColor()).endOpenElement().toMarkup();
    }

    protected String generateImgEndInsideCoolMenuTabularTag(WallImg img) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.appendText(this.generateImgTag(img));
        tagBuilder.openElement("br");
        return tagBuilder.toMarkup();
    }

    protected String generateInputDefaultStartTag(WallInput tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("input").appendAttribute("type", tag.getType()).appendAttribute("name", tag.getName()).appendAttribute("value", tag.getValue());
        tagBuilder.appendAttribute("acceskey", tag.getAccesskey());
        tagBuilder.appendAttribute("maxlength", tag.getMaxlength());
        if (StringUtils.isNotBlank((String)tag.getChecked())) {
            tagBuilder.appendText(" checked");
        }
        tagBuilder.appendAttribute("size", tag.getSize());
        if (StringUtils.equals((String)"text", (String)tag.getType()) && StringUtils.isNotBlank((String)tag.getFormat()) && NUMERIC_FORMAT_PATTERN.matcher(tag.getFormat()).matches()) {
            tagBuilder.appendAttribute("istyle", "4");
        }
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    protected String generateInputSubmitStartTag(WallInput tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("input").appendAttribute("type", "submit").appendAttribute("value", tag.getValue()).endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateMarqueeStartTag(WallMarquee marquee) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("marquee");
        tagBuilder.appendAttribute("behavior", marquee.getBehavior());
        tagBuilder.appendAttribute("direction", marquee.getDirection());
        tagBuilder.appendAttribute("loop", marquee.getLoop());
        tagBuilder.appendAttribute("bgcolor", marquee.getBgcolor());
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateMarqueeEndTag(WallMarquee marquee) {
        return "</marquee>";
    }

    public String generateMenuStartTag(WallMenu menu) {
        return "<br clear=\"all\">";
    }

    public String generateMenuEndTag(WallMenu menu) {
        return "";
    }

    public String generateOptionStartTag(WallOption tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("option").appendAttribute("value", ObjectUtils.toString((Object)tag.getValue()));
        if (StringUtils.equals((String)"selected", (String)StringUtils.trimToNull((String)tag.getSelected()))) {
            tagBuilder.appendText(" selected");
        }
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateXmlPIDTDStartTag(WallXmlpidtd dtd) {
        return "";
    }

    public String generateXmlPIDTDEndTag(WallXmlpidtd dtd) {
        return "";
    }

    protected String getImodeRegion(Device device) {
        String region = device.getCapability("imode_region");
        return region;
    }
}

